/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jboss.byteman.contrib.bmunit.BMUnit;
import org.jboss.byteman.contrib.bmunit.BMUnit5AbstractHandler;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitConfigState;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class BMUnit5ConfigHandler
extends BMUnit5AbstractHandler<BMUnitConfig> {
    public BMUnit5ConfigHandler() {
        super(BMUnitConfig.class);
    }

    @Override
    public void beforeAll(ExtensionContext context) throws Exception {
        if (BMUnit.isBMUnitVerbose()) {
            System.out.println(this.getClass().getName() + ".beforeAll");
        }
        Class testClass = context.getRequiredTestClass();
        Optional optionalAnnotation = AnnotationSupport.findAnnotation((AnnotatedElement)testClass, (Class)this.annotationClass);
        System.out.println(this.getClass().getName() + " installing " + testClass.getCanonicalName());
        if (!optionalAnnotation.isPresent()) {
            this.install((Class<?>)testClass, (Method)null, (BMUnitConfig)null);
        } else {
            this.install((Class<?>)testClass, (Method)null, (BMUnitConfig)optionalAnnotation.get());
        }
    }

    @Override
    protected void install(Class<?> testClass, Method testMethod, BMUnitConfig bmUnitConfig) throws Exception {
        if (testMethod != null) {
            BMUnitConfigState.pushConfigurationState((BMUnitConfig)bmUnitConfig, (Method)testMethod);
        } else {
            BMUnitConfigState.pushConfigurationState((BMUnitConfig)bmUnitConfig, testClass);
        }
    }

    @Override
    protected void uninstall(Class<?> testClass, Method testMethod, BMUnitConfig bmUnitConfig) throws Exception {
        if (testMethod != null) {
            BMUnitConfigState.popConfigurationState((Method)testMethod);
        } else {
            BMUnitConfigState.popConfigurationState(testClass);
        }
    }
}

