/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jboss.byteman.contrib.bmunit.BMUnit;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public abstract class BMUnit5AbstractHandler<A extends Annotation>
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    protected final Class<A> annotationClass;

    protected BMUnit5AbstractHandler(Class<A> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public Class<A> getAnnotationClass() {
        return this.annotationClass;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClass;
        Optional optionalAnnotation;
        if (BMUnit.isBMUnitVerbose()) {
            System.out.println(this.getClass().getName() + ".beforeAll");
        }
        if ((optionalAnnotation = AnnotationSupport.findAnnotation((AnnotatedElement)(testClass = context.getRequiredTestClass()), this.annotationClass)).isPresent()) {
            if (BMUnit.isBMUnitVerbose()) {
                System.out.println(this.getClass().getName() + " installing " + testClass.getCanonicalName());
            }
            this.install(testClass, null, (Annotation)optionalAnnotation.get());
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (BMUnit.isBMUnitVerbose()) {
            System.out.println(this.getClass().getName() + ".beforeEach");
        }
        Class testClass = context.getRequiredTestClass();
        Optional testMethod = context.getTestMethod();
        if (!testMethod.isPresent()) {
            return;
        }
        Optional optionalAnnotation = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)testMethod.get()), this.annotationClass);
        if (optionalAnnotation.isPresent()) {
            if (BMUnit.isBMUnitVerbose()) {
                System.out.println(this.getClass().getName() + " installing " + testClass.getCanonicalName() + "::" + ((Method)testMethod.get()).getName());
            }
            this.install(testClass, (Method)testMethod.get(), (Annotation)optionalAnnotation.get());
        }
    }

    protected abstract void install(Class<?> var1, Method var2, A var3) throws Exception;

    public void afterAll(ExtensionContext context) throws Exception {
        Class testClass;
        Optional optionalAnnotation;
        if (BMUnit.isBMUnitVerbose()) {
            System.out.println(this.getClass().getName() + ".afterAll");
        }
        if ((optionalAnnotation = AnnotationSupport.findAnnotation((AnnotatedElement)(testClass = context.getRequiredTestClass()), this.annotationClass)).isPresent()) {
            this.uninstall(testClass, null, (Annotation)optionalAnnotation.get());
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (BMUnit.isBMUnitVerbose()) {
            System.out.println(this.getClass().getName() + ".afterEach");
        }
        Class testClass = context.getRequiredTestClass();
        Optional testMethod = context.getTestMethod();
        if (!testMethod.isPresent()) {
            return;
        }
        Optional optionalAnnotation = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)testMethod.get()), this.annotationClass);
        if (optionalAnnotation.isPresent()) {
            if (BMUnit.isBMUnitVerbose()) {
                System.out.println(this.getClass().getName() + " uninstalling " + testClass.getCanonicalName() + "::" + ((Method)testMethod.get()).getName());
            }
            this.uninstall(testClass, (Method)testMethod.get(), (Annotation)optionalAnnotation.get());
        }
    }

    protected abstract void uninstall(Class<?> var1, Method var2, A var3) throws Exception;
}

