/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.dtest;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.byteman.agent.submit.ScriptText;
import org.jboss.byteman.agent.submit.Submit;
import org.jboss.byteman.contrib.dtest.BytemanTestHelper;
import org.jboss.byteman.contrib.dtest.InstrumentedClass;
import org.jboss.byteman.contrib.dtest.RemoteInterface;
import org.jboss.byteman.contrib.dtest.RuleBuilder;

public class Instrumentor {
    private static final int DEFAULT_RMI_PORT = 1099;
    private final Submit submit;
    private final Registry registry;
    private final int rmiRegistryPort;
    private final Map<String, InstrumentedClass> instrumentedClasses = new HashMap<String, InstrumentedClass>();
    private final List<ScriptText> installedScripts = new LinkedList<ScriptText>();
    private File redirectedSubmissionsFile;

    public Instrumentor(Submit submit, int rmiRegistryPort) throws RemoteException {
        this.submit = submit;
        this.rmiRegistryPort = rmiRegistryPort;
        this.registry = LocateRegistry.createRegistry(rmiRegistryPort);
    }

    public Instrumentor() throws RemoteException {
        this(new Submit(), 1099);
    }

    public Instrumentor(String address, int port) throws RemoteException {
        this(new Submit(address, port), 1099);
    }

    public Instrumentor(String address, int port, int rmiPort) throws RemoteException {
        this(new Submit(address, port), rmiPort);
    }

    public void installHelperJar(String path) throws Exception {
        LinkedList<String> jarPaths = new LinkedList<String>();
        jarPaths.add(path);
        this.submit.addJarsToSystemClassloader(jarPaths);
        Properties properties = new Properties();
        properties.setProperty("org.jboss.byteman.contrib.dtest.rmiregistry.port", "" + this.rmiRegistryPort);
        this.submit.setSystemProperties(properties);
    }

    public InstrumentedClass instrumentClass(Class clazz) throws Exception {
        return this.instrumentClass(clazz, null);
    }

    public InstrumentedClass instrumentClass(Class clazz, Set<String> methodNames) throws Exception {
        String className = clazz.getCanonicalName();
        StringBuilder ruleScriptBuilder = new StringBuilder();
        for (Method method : clazz.getDeclaredMethods()) {
            String methodName = method.getName();
            if (methodNames != null && !methodNames.contains(methodName)) continue;
            String ruleName = this.getClass().getCanonicalName() + "_" + className + "_" + methodName + "_remotetrace_entry";
            RuleBuilder ruleBuilder = new RuleBuilder(ruleName);
            ruleBuilder.onClass(className).inMethod(methodName).atEntry();
            ruleBuilder.usingHelper(BytemanTestHelper.class);
            ruleBuilder.doAction("setTriggering(false), debug(\"firing " + ruleName + "\", $0), remoteTrace(\"" + className + "\", \"" + methodName + "\", $*)");
            ruleScriptBuilder.append(ruleBuilder.toString());
        }
        String scriptString = ruleScriptBuilder.toString();
        this.installScript(className + ".instrumentationScript", scriptString);
        return this.publish(className);
    }

    public File getRedirectedSubmissionsFile() {
        return this.redirectedSubmissionsFile;
    }

    public void setRedirectedSubmissionsFile(File redirectedSubmissionsFile) {
        this.redirectedSubmissionsFile = redirectedSubmissionsFile;
    }

    public void injectOnCall(Class clazz, String methodName, String action) throws Exception {
        String className = clazz.getCanonicalName();
        String ruleName = this.getClass().getCanonicalName() + "_" + className + "_" + methodName + "_callinjection";
        RuleBuilder ruleBuilder = new RuleBuilder(ruleName);
        ruleBuilder.onClass(className).inMethod(methodName).atEntry();
        ruleBuilder.usingHelper(BytemanTestHelper.class);
        ruleBuilder.whenTrue().doAction(action);
        String ruleText = ruleBuilder.toString();
        this.installScript("onCall" + className + "." + methodName, ruleText);
    }

    public void injectFault(Class clazz, String methodName, Class<? extends Throwable> fault, Object[] faultArgs) throws Exception {
        String className = clazz.getCanonicalName();
        String ruleName = this.getClass().getCanonicalName() + "_" + className + "_" + methodName + "_faultinjection";
        StringBuilder actionBuilder = new StringBuilder();
        actionBuilder.append("setTriggering(false), debug(\"firing " + ruleName + "\", $0), ");
        actionBuilder.append("throw new " + fault.getCanonicalName() + "(");
        if (faultArgs != null) {
            for (int i = 0; i < faultArgs.length; ++i) {
                String argClassName = faultArgs[i].getClass().getCanonicalName();
                boolean requireQuotes = true;
                if (argClassName.startsWith("java.lang.") && !argClassName.equals("java.lang.String")) {
                    requireQuotes = false;
                }
                if (requireQuotes) {
                    actionBuilder.append("\"");
                }
                actionBuilder.append(faultArgs[i]);
                if (requireQuotes) {
                    actionBuilder.append("\"");
                }
                if (i == faultArgs.length - 1) continue;
                actionBuilder.append(", ");
            }
        }
        actionBuilder.append(")\n");
        RuleBuilder ruleBuilder = new RuleBuilder(ruleName);
        ruleBuilder.onClass(className).inMethod(methodName).atEntry();
        ruleBuilder.usingHelper(BytemanTestHelper.class);
        ruleBuilder.whenTrue().doAction(actionBuilder.toString());
        this.installScript("fault" + className + "." + methodName, ruleBuilder.toString());
    }

    public void crashAtMethodExit(Class clazz, String methodName) throws Exception {
        String className = clazz.getCanonicalName();
        this.crashAtMethod(className, methodName, "EXIT");
    }

    public void crashAtMethodExit(String className, String methodName) throws Exception {
        this.crashAtMethod(className, methodName, "EXIT");
    }

    public void crashAtMethodEntry(Class clazz, String methodName) throws Exception {
        String className = clazz.getCanonicalName();
        this.crashAtMethod(className, methodName, "ENTRY");
    }

    public void crashAtMethodEntry(String className, String methodName) throws Exception {
        this.crashAtMethod(className, methodName, "ENTRY");
    }

    public void crashAtMethod(String className, String methodName, String where) throws Exception {
        String ruleName = this.getClass().getCanonicalName() + "_" + className + "_" + methodName + "_crashatexit";
        String action = "debug(\"killing JVM\"), killJVM()";
        RuleBuilder ruleBuilder = new RuleBuilder(ruleName);
        ruleBuilder.onClass(className).inMethod(methodName).at(where);
        ruleBuilder.usingHelper(BytemanTestHelper.class);
        ruleBuilder.whenTrue().doAction(action);
        this.installScript("crash" + className + "." + methodName, ruleBuilder.toString());
    }

    private void installScript(String scriptName, String scriptString) throws Exception {
        System.out.println("installing: " + scriptString);
        if (scriptString.length() > 0) {
            if (this.redirectedSubmissionsFile == null) {
                ScriptText scriptText = new ScriptText(scriptName, scriptString);
                LinkedList<ScriptText> scriptTexts = new LinkedList<ScriptText>();
                scriptTexts.add(scriptText);
                this.submit.addScripts(scriptTexts);
                this.installedScripts.addAll(scriptTexts);
            } else {
                this.appendToFile(this.redirectedSubmissionsFile, scriptString);
                ScriptText installedScriptText = null;
                ScriptText updatedScriptText = null;
                for (ScriptText scriptText : this.installedScripts) {
                    if (!scriptText.getFileName().equals(this.redirectedSubmissionsFile.getCanonicalPath())) continue;
                    installedScriptText = scriptText;
                }
                if (installedScriptText != null) {
                    this.installedScripts.remove(installedScriptText);
                    updatedScriptText = new ScriptText(installedScriptText.getFileName(), installedScriptText.getText() + scriptString);
                } else {
                    updatedScriptText = new ScriptText(this.redirectedSubmissionsFile.getCanonicalPath(), scriptString);
                }
                this.installedScripts.add(updatedScriptText);
            }
        }
    }

    private void appendToFile(File file, String rule) throws Exception {
        FileWriter writer = new FileWriter(file, true);
        writer.write(rule);
        ((Writer)writer).close();
    }

    private synchronized InstrumentedClass publish(String className) throws Exception {
        if (this.instrumentedClasses.containsKey(className)) {
            return this.instrumentedClasses.get(className);
        }
        InstrumentedClass instrumentedClass = new InstrumentedClass(className);
        RemoteInterface stub = (RemoteInterface)UnicastRemoteObject.exportObject((Remote)instrumentedClass, 0);
        this.registry.rebind(className, stub);
        this.instrumentedClasses.put(className, instrumentedClass);
        return instrumentedClass;
    }

    private void unpublish(String className) throws Exception {
        this.registry.unbind(className);
    }

    public void removeLocalState() throws Exception {
        for (String instrumentedClassName : this.instrumentedClasses.keySet()) {
            this.unpublish(instrumentedClassName);
        }
        this.instrumentedClasses.clear();
        this.installedScripts.clear();
    }

    public void removeAllInstrumentation() throws Exception {
        this.submit.deleteScripts(this.installedScripts);
        this.removeLocalState();
    }
}

