/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.dtest;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.byteman.contrib.dtest.CallCount;
import org.jboss.byteman.contrib.dtest.InstrumentedInstance;
import org.jboss.byteman.contrib.dtest.RemoteInterface;
import org.junit.Assert;

public class InstrumentedClass
implements RemoteInterface {
    private static final Integer STATIC_INSTANCE_ID = new Integer(-1);
    private final String className;
    private final Map<Integer, InstrumentedInstance> instrumentedInstances = new ConcurrentHashMap<Integer, InstrumentedInstance>();

    InstrumentedClass(String className) {
        this.className = className;
    }

    @Override
    public void trace(String methodName, Object[] args) throws RemoteException {
        InstrumentedInstance createdInstrumentedInstance;
        InstrumentedInstance instrumentedInstance;
        Integer objectId = (Integer)args[0];
        if (objectId == null) {
            objectId = STATIC_INSTANCE_ID;
        }
        if ((instrumentedInstance = this.instrumentedInstances.putIfAbsent(objectId, createdInstrumentedInstance = new InstrumentedInstance(this.className, objectId))) == null) {
            instrumentedInstance = createdInstrumentedInstance;
        }
        Object[] innerArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, innerArgs, 0, innerArgs.length);
        instrumentedInstance.addMethodTrace(methodName, innerArgs);
    }

    public Set<InstrumentedInstance> getInstances() {
        return new HashSet<InstrumentedInstance>(this.instrumentedInstances.values());
    }

    public int getInvocationCount(String methodName) {
        int invocationCount = 0;
        for (InstrumentedInstance instance : this.getInstances()) {
            invocationCount += instance.getInvocationCount(methodName);
        }
        return invocationCount;
    }

    public void assertKnownInstances(int count) {
        Assert.assertEquals((String)("Number of known instances of " + this.className + " does not match"), (long)count, (long)this.instrumentedInstances.size());
    }

    public void assertMethodCallCount(String message, String methodName, CallCount callCount) {
        for (InstrumentedInstance instance : this.getInstances()) {
            instance.assertMethodCallCount(message, methodName, callCount);
        }
    }

    public void assertMethodCallCount(String message, String methodName, int callCount) {
        this.assertMethodCallCount(message, methodName, new CallCount(callCount, callCount));
    }

    public void assertMethodCallCount(String methodName, int callCount) {
        this.assertMethodCallCount(null, methodName, new CallCount(callCount, callCount));
    }

    public void assertSumMethodCallCount(String method, int callCount) {
        Assert.assertEquals((String)("Method " + this.className + "#" + method + " was not called " + callCount + " times"), (long)callCount, (long)this.getInvocationCount(method));
    }

    public void assertMethodCalled(String methodName) {
        this.assertMethodCallCount(null, methodName, new CallCount(1, Integer.MAX_VALUE));
    }

    public void assertMethodNotCalled(String methodName) {
        this.assertMethodCallCount(null, methodName, new CallCount(0, 0));
    }
}

