/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.dtest;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.byteman.agent.submit.ScriptText;
import org.jboss.byteman.agent.submit.Submit;
import org.jboss.byteman.contrib.dtest.BytemanTestHelper;
import org.jboss.byteman.contrib.dtest.InstrumentedClass;
import org.jboss.byteman.contrib.dtest.RemoteInterface;
import org.jboss.byteman.contrib.dtest.RuleConstructor;

public class Instrumentor {
    private final Submit submit;
    private final Registry registry;
    private final int rmiRegistryPort;
    private final Map<String, InstrumentedClass> instrumentedClasses = new HashMap<String, InstrumentedClass>();
    private final List<ScriptText> installedScripts = new LinkedList<ScriptText>();
    private File redirectedSubmissionsFile;
    private Class<?> helperClass = BytemanTestHelper.class;

    public Instrumentor(Submit submit, int rmiRegistryPort) throws RemoteException {
        this.submit = submit;
        this.rmiRegistryPort = rmiRegistryPort;
        this.registry = LocateRegistry.createRegistry(rmiRegistryPort);
    }

    public Instrumentor() throws RemoteException {
        this(new Submit(), 1099);
    }

    public Instrumentor(String address, int port) throws RemoteException {
        this(new Submit(address, port), 1099);
    }

    public Instrumentor(String address, int port, int rmiPort) throws RemoteException {
        this(new Submit(address, port), rmiPort);
    }

    public File getRedirectedSubmissionsFile() {
        return this.redirectedSubmissionsFile;
    }

    public void setRedirectedSubmissionsFile(File redirectedSubmissionsFile) {
        this.redirectedSubmissionsFile = redirectedSubmissionsFile;
    }

    public Class<?> getHelperClass() {
        return this.helperClass;
    }

    public void setHelperClass(Class<?> helperClass) {
        this.helperClass = helperClass;
    }

    public void installHelperJar(String path) throws Exception {
        LinkedList<String> jarPaths = new LinkedList<String>();
        jarPaths.add(path);
        this.submit.addJarsToSystemClassloader(jarPaths);
        Properties properties = new Properties();
        properties.setProperty("org.jboss.byteman.contrib.dtest.rmiregistry.port", "" + this.rmiRegistryPort);
        this.submit.setSystemProperties(properties);
    }

    public InstrumentedClass instrumentClass(Class clazz) throws Exception {
        Set<String> nullSet = null;
        return this.instrumentClass(clazz, nullSet);
    }

    public InstrumentedClass instrumentClass(Class clazz, String ... methodNames) throws Exception {
        if (methodNames == null) {
            Set<String> nullSet = null;
            return this.instrumentClass(clazz, nullSet);
        }
        return this.instrumentClass(clazz, new HashSet<String>(Arrays.asList(methodNames)));
    }

    public InstrumentedClass instrumentClass(Class clazz, Set<String> methodNames) throws Exception {
        String className = clazz.getCanonicalName();
        HashSet<String> methodNamesToInstrument = new HashSet<String>();
        for (Method method : clazz.getDeclaredMethods()) {
            String declaredMethodName = method.getName();
            if (methodNames != null && !methodNames.contains(declaredMethodName)) continue;
            methodNamesToInstrument.add(declaredMethodName);
        }
        return this.instrumentClass(className, methodNamesToInstrument);
    }

    public InstrumentedClass instrumentClass(String className, String ... methodNames) throws Exception {
        return this.instrumentClass(className, new HashSet<String>(Arrays.asList(methodNames)));
    }

    public InstrumentedClass instrumentClass(String className, Set<String> methodNames) throws Exception {
        if (methodNames == null) {
            throw new NullPointerException("methodNames");
        }
        HashSet<String> instrumentedMethods = new HashSet<String>();
        StringBuilder ruleScriptBuilder = new StringBuilder();
        for (String methodName : methodNames) {
            if (instrumentedMethods.contains(methodName)) continue;
            String ruleName = this.getClass().getCanonicalName() + "_" + className + "_" + methodName + "_remotetrace_entry";
            RuleConstructor.ClassClause builderClassClause = RuleConstructor.createRule(ruleName);
            RuleConstructor.MethodClause builderMethodClause = this.isInterface(className) ? builderClassClause.onInterface(className) : builderClassClause.onClass(className);
            RuleConstructor builder = builderMethodClause.inMethod(methodName).atEntry().helper(this.helperClass).ifTrue().doAction("setTriggering(false), debug(\"firing " + ruleName + "\", $0), remoteTrace(\"" + className + "\", \"" + methodName + "\", $*)");
            ruleScriptBuilder.append(builder.build());
            instrumentedMethods.add(methodName);
        }
        String scriptString = ruleScriptBuilder.toString();
        this.installScript(className + ".instrumentationScript", scriptString);
        return this.publish(className);
    }

    public void injectOnCall(Class clazz, String methodName, String action) throws Exception {
        this.injectOnCall(clazz.getCanonicalName(), methodName, action);
    }

    public void injectOnCall(String className, String methodName, String action) throws Exception {
        this.injectOnMethod(className, methodName, "true", action, "ENTRY");
    }

    public void injectOnExit(Class clazz, String methodName, String action) throws Exception {
        this.injectOnExit(clazz.getCanonicalName(), methodName, action);
    }

    public void injectOnExit(String className, String methodName, String action) throws Exception {
        this.injectOnMethod(className, methodName, "true", action, "EXIT");
    }

    public void injectOnMethod(Class clazz, String methodName, String condition, String action, String atInjection) throws Exception {
        this.injectOnMethod(clazz.getCanonicalName(), methodName, condition, action, atInjection);
    }

    public void injectOnMethod(String className, String methodName, String condition, String action, String atInjection) throws Exception {
        String ruleName = this.getClass().getCanonicalName() + "_" + className + "_" + methodName + "_injectionat" + atInjection;
        RuleConstructor.ClassClause builderClassClause = RuleConstructor.createRule(ruleName);
        RuleConstructor.MethodClause builderMethodClause = this.isInterface(className) ? builderClassClause.onInterface(className) : builderClassClause.onClass(className);
        RuleConstructor builder = builderMethodClause.inMethod(methodName).at(atInjection).helper(this.helperClass).ifCondition(condition).doAction(action);
        this.installScript("onCall" + className + "." + methodName + "." + atInjection, builder.build());
    }

    public void injectOnMethodWhere(Class clazz, String methodName, String condition, String action, String where) throws Exception {
        this.injectOnMethodWhere(clazz.getCanonicalName(), methodName, condition, action, where);
    }

    public void injectOnMethodWhere(String className, String methodName, String condition, String action, String where) throws Exception {
        String ruleName = this.getClass().getCanonicalName() + "_" + className + "_" + methodName + "_injectionat" + where;
        RuleConstructor.ClassClause builderClassClause = RuleConstructor.createRule(ruleName);
        RuleConstructor.MethodClause builderMethodClause = this.isInterface(className) ? builderClassClause.onInterface(className) : builderClassClause.onClass(className);
        RuleConstructor builder = builderMethodClause.inMethod(methodName).where(where).helper(this.helperClass).ifCondition(condition).doAction(action);
        this.installScript("onCall" + className + "." + methodName + "." + where, builder.build());
    }

    public void injectFault(Class clazz, String methodName, Class<? extends Throwable> fault, Object[] faultArgs) throws Exception {
        String className = clazz.getCanonicalName();
        String ruleName = this.getClass().getCanonicalName() + "_" + className + "_" + methodName + "_faultinjection";
        StringBuilder actionBuilder = new StringBuilder();
        actionBuilder.append("setTriggering(false), debug(\"firing " + ruleName + "\", $0), ");
        actionBuilder.append("throw new " + fault.getCanonicalName() + "(");
        if (faultArgs != null) {
            for (int i = 0; i < faultArgs.length; ++i) {
                String argClassName = faultArgs[i].getClass().getCanonicalName();
                boolean requireQuotes = true;
                if (argClassName.startsWith("java.lang.") && !argClassName.equals("java.lang.String")) {
                    requireQuotes = false;
                }
                if (requireQuotes) {
                    actionBuilder.append("\"");
                }
                actionBuilder.append(faultArgs[i]);
                if (requireQuotes) {
                    actionBuilder.append("\"");
                }
                if (i == faultArgs.length - 1) continue;
                actionBuilder.append(", ");
            }
        }
        actionBuilder.append(")\n");
        RuleConstructor.ClassClause builderClassClause = RuleConstructor.createRule(ruleName);
        RuleConstructor.MethodClause builderMethodClause = this.isInterface(className) ? builderClassClause.onInterface(className) : builderClassClause.onClass(className);
        RuleConstructor builder = builderMethodClause.inMethod(methodName).atEntry().helper(this.helperClass).ifTrue().doAction(actionBuilder.toString());
        this.installScript("fault" + className + "." + methodName, builder.build());
    }

    public void crashAtMethodExit(Class clazz, String methodName) throws Exception {
        this.crashAtMethodExit(clazz.getCanonicalName(), methodName);
    }

    public void crashAtMethodExit(String className, String methodName) throws Exception {
        this.crashAtMethod(className, methodName, "EXIT");
    }

    public void crashAtMethodEntry(Class clazz, String methodName) throws Exception {
        this.crashAtMethodEntry(clazz.getCanonicalName(), methodName);
    }

    public void crashAtMethodEntry(String className, String methodName) throws Exception {
        this.crashAtMethod(className, methodName, "ENTRY");
    }

    public void crashAtMethod(String className, String methodName, String atInjection) throws Exception {
        String ruleName = this.getClass().getCanonicalName() + "_" + className + "_" + methodName + "_crashat" + atInjection;
        String action = "debug(\"killing JVM\"), killJVM()";
        RuleConstructor.ClassClause builderClassClause = RuleConstructor.createRule(ruleName);
        RuleConstructor.MethodClause builderMethodClause = this.isInterface(className) ? builderClassClause.onInterface(className) : builderClassClause.onClass(className);
        RuleConstructor builder = builderMethodClause.inMethod(methodName).at(atInjection).helper(this.helperClass).ifTrue().doAction(action);
        this.installScript("crash" + className + "." + methodName + "." + atInjection, builder.build());
    }

    public void installScript(String scriptName, String scriptString) throws Exception {
        System.out.println("installing: " + scriptString);
        if (scriptString.length() > 0) {
            if (this.redirectedSubmissionsFile == null) {
                ScriptText scriptText = new ScriptText(scriptName, scriptString);
                LinkedList<ScriptText> scriptTexts = new LinkedList<ScriptText>();
                scriptTexts.add(scriptText);
                this.submit.addScripts(scriptTexts);
                this.installedScripts.addAll(scriptTexts);
            } else {
                this.appendToFile(this.redirectedSubmissionsFile, scriptString);
                ScriptText installedScriptText = null;
                ScriptText updatedScriptText = null;
                for (ScriptText scriptText : this.installedScripts) {
                    if (!scriptText.getFileName().equals(this.redirectedSubmissionsFile.getCanonicalPath())) continue;
                    installedScriptText = scriptText;
                }
                if (installedScriptText != null) {
                    this.installedScripts.remove(installedScriptText);
                    updatedScriptText = new ScriptText(installedScriptText.getFileName(), installedScriptText.getText() + scriptString);
                } else {
                    updatedScriptText = new ScriptText(this.redirectedSubmissionsFile.getCanonicalPath(), scriptString);
                }
                this.installedScripts.add(updatedScriptText);
            }
        }
    }

    public String installRule(RuleConstructor builder) throws Exception {
        String scriptName = builder.getRuleName();
        this.installScript(scriptName, builder.build());
        return scriptName;
    }

    public void removeScript(String scriptName) throws Exception {
        ScriptText script = this.findInstalledScript(scriptName);
        if (script == null) {
            throw new IllegalStateException("Script name " + scriptName + " can't be removed as was not found in list of installed scripts");
        }
        this.submit.deleteScripts(Arrays.asList(script));
        this.installedScripts.remove(script);
    }

    public void removeRule(RuleConstructor builder) throws Exception {
        String scriptName = builder.getRuleName();
        this.removeScript(scriptName);
    }

    public synchronized void removeLocalState() throws Exception {
        for (String instrumentedClassName : this.instrumentedClasses.keySet()) {
            this.unpublish(instrumentedClassName);
        }
        this.instrumentedClasses.clear();
        this.installedScripts.clear();
    }

    public void removeAllInstrumentation() throws Exception {
        this.submit.deleteScripts(this.installedScripts);
        this.removeLocalState();
    }

    private void appendToFile(File file, String rule) throws Exception {
        FileWriter writer = new FileWriter(file, true);
        writer.write(rule);
        ((Writer)writer).close();
    }

    private synchronized InstrumentedClass publish(String className) throws Exception {
        if (this.instrumentedClasses.containsKey(className)) {
            return this.instrumentedClasses.get(className);
        }
        InstrumentedClass instrumentedClass = new InstrumentedClass(className);
        RemoteInterface stub = (RemoteInterface)UnicastRemoteObject.exportObject((Remote)instrumentedClass, 0);
        this.registry.rebind(className, stub);
        this.instrumentedClasses.put(className, instrumentedClass);
        return instrumentedClass;
    }

    private void unpublish(String className) throws Exception {
        this.registry.unbind(className);
    }

    private boolean isInterface(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clazz != null) {
            return clazz.isInterface();
        }
        return false;
    }

    private ScriptText findInstalledScript(String scriptName) {
        for (ScriptText installedScript : this.installedScripts) {
            if (!installedScript.getFileName().equals(scriptName)) continue;
            return installedScript;
        }
        return null;
    }
}

