/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.install;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarFile;

public class Install {
    private String agentJar = null;
    private int pid = 0;
    private int port = 0;
    private String host;
    private boolean addToBoot = false;
    private String props = "";
    private VirtualMachine vm = null;
    private static final String BYTEMAN_PREFIX = "org.jboss.byteman.";

    public static void main(String[] args) {
        Install attachTest = new Install();
        attachTest.parseArgs(args);
        attachTest.locateAgent();
        attachTest.attach();
        attachTest.injectAgent();
    }

    private Install() {
    }

    private void parseArgs(String[] args) {
        int idx = 0;
        int argCount = args.length;
        if (idx == argCount) {
            Install.usage(0);
        }
        String nextArg = args[idx];
        while (nextArg.length() != 0 && nextArg.charAt(0) == '-') {
            if (nextArg.equals("-p")) {
                if (++idx == argCount) {
                    Install.usage(1);
                }
                nextArg = args[idx];
                ++idx;
                try {
                    this.port = Integer.decode(nextArg);
                }
                catch (NumberFormatException e) {
                    System.out.println("Install : invalid value for port " + nextArg);
                    Install.usage(1);
                }
            } else if (nextArg.equals("-h")) {
                if (++idx == argCount) {
                    Install.usage(1);
                }
                nextArg = args[idx];
                ++idx;
                this.host = nextArg;
            } else if (nextArg.equals("-b")) {
                ++idx;
                this.addToBoot = true;
            } else if (nextArg.startsWith("-D")) {
                ++idx;
                String prop = nextArg.substring(2);
                if (!prop.startsWith(BYTEMAN_PREFIX) || prop.contains(",")) {
                    System.out.println("Install : invalid property setting " + prop);
                    Install.usage(1);
                }
                this.props = this.props + ",prop:" + prop;
            } else if (nextArg.equals("--help")) {
                Install.usage(0);
            } else {
                System.out.println("Install : invalid option " + args[idx]);
                Install.usage(1);
            }
            if (idx == argCount) {
                Install.usage(1);
            }
            nextArg = args[idx];
        }
        if (idx != argCount - 1) {
            Install.usage(1);
        }
        try {
            this.pid = Integer.decode(nextArg);
        }
        catch (NumberFormatException e) {
            System.out.println("Install : invalid value for process id " + nextArg);
            Install.usage(1);
        }
    }

    private void locateAgent() {
        File bmLibFile;
        File bmHomeFile;
        String bmHome = System.getenv("BYTEMAN_HOME");
        if (bmHome == null || bmHome.length() == 0) {
            System.out.println("Install : please set environment variable BYTEMAN_HOME");
        }
        if (bmHome.endsWith("/")) {
            bmHome = bmHome.substring(0, bmHome.length() - 1);
        }
        if (!(bmHomeFile = new File(bmHome)).isDirectory()) {
            System.out.println("Install : ${BYTEMAN_HOME} does not identify a directory");
        }
        if (!(bmLibFile = new File(bmHome + "/lib")).isDirectory()) {
            System.out.println("Install : ${BYTEMAN_HOME}/lib does not identify a directory");
        }
        try {
            JarFile bytemanJarFile = new JarFile(bmHome + "/lib/byteman.jar");
        }
        catch (IOException e) {
            System.out.println("Install : ${BYTEMAN_HOME}/lib/byteman.jar is not a valid jar file");
        }
        this.agentJar = bmHome + "/lib/byteman.jar";
    }

    private void attach() {
        Properties properties = null;
        try {
            this.vm = VirtualMachine.attach(Integer.toString(this.pid));
        }
        catch (AttachNotSupportedException e) {
            System.out.println("Install : unable to attach to process " + this.pid);
            e.printStackTrace();
            System.exit(2);
        }
        catch (IOException e) {
            System.out.println("Install : I/O exception attaching to process " + this.pid);
            e.printStackTrace();
            System.exit(3);
        }
        try {
            properties = this.vm.getAgentProperties();
        }
        catch (IOException e) {
            System.out.println("Install : I/O exception fetching agent properties " + this.pid);
            e.printStackTrace();
            System.exit(4);
        }
    }

    private void injectAgent() {
        if (this.agentJar != null) {
            String agentOptions = "listener:true";
            if (this.host != null && this.host.length() != 0) {
                agentOptions = agentOptions + ",address:" + this.host;
            }
            if (this.port != 0) {
                agentOptions = agentOptions + ",port:" + this.port;
            }
            if (this.addToBoot) {
                agentOptions = agentOptions + ",boot:" + this.agentJar;
            }
            if (this.props != null) {
                agentOptions = agentOptions + this.props;
            }
            try {
                this.vm.loadAgent(this.agentJar, agentOptions);
            }
            catch (AgentLoadException e) {
                System.out.println("Install :load exception loading agent");
                e.printStackTrace();
                System.exit(5);
            }
            catch (AgentInitializationException e) {
                System.out.println("Install : initialization exception loading agent");
                e.printStackTrace();
                System.exit(6);
            }
            catch (IOException e) {
                System.out.println("Install : I/O exception loading agent");
                e.printStackTrace();
                System.exit(7);
            }
        }
        if (this.vm != null) {
            try {
                this.vm.detach();
            }
            catch (IOException e) {
                System.out.println("Install : I/O exception detaching from process " + this.pid);
                e.printStackTrace();
                System.exit(8);
            }
        }
    }

    private static void usage(int exitValue) {
        System.out.println("usage : Install [-h host] [-p porm] [-b] [-Dprop[=value]]* pid");
        System.out.println("        upload the byteman agent into a running JVM");
        System.out.println("    pid is the process id of the target JVM");
        System.out.println("    -h host selects the host name or address the agent listener binds to");
        System.out.println("    -p port selects the port the agent listener binds to");
        System.out.println("    -b adds the byteman jar to the bootstrap classpath");
        System.out.println("    -Dname=value can be used to set system properties whose name starts with \"org.jboss.byteman.\"");
        System.out.println("    expects to find a byteman agent jar in $BYTEMAN_HOME/lib/byteman.jar");
        System.exit(exitValue);
    }
}

