/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.rulecheck;

import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.byteman.check.RuleCheck;
import org.jboss.byteman.check.RuleCheckResult;

@Mojo(name="rulecheck", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RuleCheckMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private PluginDescriptor descriptor;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", property="scriptDir", required=true)
    private File scriptDir;
    @Parameter(property="packages")
    private String[] packages;
    @Parameter(defaultValue="true", property="failOnError")
    private boolean failOnError;
    @Parameter(defaultValue="true", property="failOnWarning")
    private boolean failOnWarning;
    @Parameter(defaultValue="0", property="expectWarnings")
    private int expectWarnings;
    @Parameter(defaultValue="false", property="skip")
    private boolean skip;
    @Parameter(property="includes")
    private String[] includes;
    @Parameter(property="excludes")
    private String[] excludes;
    @Parameter(property="additionalClassPath")
    private String additionalClassPath;
    @Parameter(property="systemProperties")
    private Properties systemProperties;
    @Parameter(defaultValue="false", property="verbose")
    boolean verbose;

    public void execute() throws MojoExecutionException {
        List scripts;
        int i;
        if (this.skip) {
            this.getLog().info((CharSequence)"Checking byteman scripts are skipped");
            return;
        }
        for (String key : this.systemProperties.stringPropertyNames()) {
            if (!key.matches("[-A-Za-z0-9_$.]+")) {
                throw new MojoExecutionException("invalid system property " + key);
            }
            String value = this.systemProperties.getProperty(key);
            System.setProperty(key, value);
        }
        try {
            if (this.verbose) {
                this.getLog().info((CharSequence)("find byteman script in " + this.scriptDir));
            }
            StringBuffer includebuf = new StringBuffer();
            for (int i2 = 0; i2 < this.includes.length; ++i2) {
                includebuf.append(this.includes[i2]);
                if (i2 == this.includes.length - 1) continue;
                includebuf.append(",");
            }
            StringBuffer excludebuf = new StringBuffer();
            for (i = 0; i < this.excludes.length; ++i) {
                excludebuf.append(this.excludes[i]);
                if (i == this.excludes.length - 1) continue;
                excludebuf.append(",");
            }
            scripts = FileUtils.getFiles((File)this.scriptDir, (String)includebuf.toString(), (String)excludebuf.toString());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)("Can not find " + this.scriptDir));
            return;
        }
        if (scripts.size() == 0) {
            this.getLog().info((CharSequence)("No byteman script in " + this.scriptDir));
            return;
        }
        int n = scripts.size();
        this.getLog().info((CharSequence)("Found " + n + " scripts:"));
        for (int i3 = 0; i3 < n; ++i3) {
            this.getLog().info((CharSequence)("  " + i3 + ": " + scripts.get(i3)));
        }
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            classpathElements.addAll(this.project.getRuntimeClasspathElements());
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            classpathElements.add(this.project.getBuild().getTestOutputDirectory());
            if (this.additionalClassPath != null) {
                String[] cps = this.additionalClassPath.split(";");
                for (i = 0; i < cps.length; ++i) {
                    File file = new File(cps[i]);
                    String path = null;
                    path = file.isAbsolute() ? cps[i] : this.project.getBasedir() + File.separator + cps[i];
                    classpathElements.add(path);
                    if (!this.verbose) continue;
                    this.getLog().info((CharSequence)("add addional classpath " + path));
                }
            }
            ClassRealm realm = this.descriptor.getClassRealm();
            for (String element : classpathElements) {
                File elementFile = new File(element);
                if (this.verbose) {
                    this.getLog().info((CharSequence)element);
                } else {
                    this.getLog().debug((CharSequence)element);
                }
                realm.addURL(elementFile.toURI().toURL());
            }
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().warn((Throwable)e);
        }
        catch (MalformedURLException e) {
            this.getLog().warn((Throwable)e);
        }
        RuleCheck checker = new RuleCheck();
        for (File script : scripts) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("add script " + script));
            } else {
                this.getLog().debug((CharSequence)("add script " + script));
            }
            checker.addRuleFile(script.getAbsolutePath());
        }
        for (int i4 = 0; i4 < this.packages.length; ++i4) {
            checker.addPackage(this.packages[i4]);
            if (this.verbose) {
                this.getLog().info((CharSequence)("add package " + this.packages[i4]));
                continue;
            }
            this.getLog().debug((CharSequence)("add package " + this.packages[i4]));
        }
        this.getLog().info((CharSequence)("Checking " + scripts.size() + " byteman scripts in " + this.scriptDir));
        checker.checkRules();
        RuleCheckResult result = checker.getResult();
        if (result.hasWarning()) {
            List warns = result.getWarningMessages();
            warns.addAll(result.getTypeWarningMessages());
            for (String warn : warns) {
                this.getLog().warn((CharSequence)warn);
            }
            int totalWarnCount = warns.size();
            if (this.failOnWarning && this.expectWarnings != totalWarnCount) {
                throw new MojoExecutionException("check byteman script rules failed with " + totalWarnCount + " warnings. You may config failOnWarning with false or expectWarnings with " + totalWarnCount);
            }
        }
        if (result.hasError()) {
            int totalErrorCount = result.getErrorCount() + result.getParseErrorCount() + result.getTypeErrorCount();
            this.getLog().error((CharSequence)("Checking byteman script rules failed with " + totalErrorCount + " errors"));
            List errors = result.getErrorMessages();
            errors.addAll(result.getParseErrorMessages());
            errors.addAll(result.getTypeErrorMessages());
            for (String error : errors) {
                this.getLog().error((CharSequence)error);
            }
            if (this.failOnError) {
                throw new MojoExecutionException("check byteman script rules failed with " + totalErrorCount + " errors");
            }
        }
    }
}

