/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.interceptors.AbstractInterceptor;
import org.jboss.cache.pojo.interceptors.PojoTxSynchronizationHandler;

public class PojoTxUndoSynchronizationInterceptor
extends AbstractInterceptor {
    private static ThreadLocal synchronizationHandler_ = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation in) throws Throwable {
        if (!(in instanceof MethodInvocation)) {
            throw new IllegalArgumentException("TxSyncrhonizationInterceptor.invoke(): invocation not MethodInvocation");
        }
        MethodInvocation invocation = (MethodInvocation)in;
        this.registerTxHandler(invocation);
        Object object = invocation.invokeNext();
        return object;
    }

    private void registerTxHandler(MethodInvocation invocation) throws PojoCacheException {
        try {
            PojoTxSynchronizationHandler handler = (PojoTxSynchronizationHandler)synchronizationHandler_.get();
            if (handler == null) {
                Transaction tx = (Transaction)invocation.getMetaData((Object)"PC", (Object)"TX");
                if (tx == null) {
                    throw new IllegalStateException("PojoCache.registerTxHanlder(). Can't have null tx handle.");
                }
                handler = new PojoTxSynchronizationHandler();
                this.log.debug((Object)("Registering PojoTxSynchronizationHandler for rollback if ncessary " + handler));
                tx.registerSynchronization((Synchronization)handler);
                synchronizationHandler_.set(handler);
            }
        }
        catch (RollbackException e) {
            throw new PojoCacheException("PojoTxUndoSynchronizationInterceptor.registerTxHandler(): Exception: " + (Object)((Object)e));
        }
        catch (SystemException e) {
            throw new PojoCacheException("PojoTxUndoSynchronizationInterceptor.registerTxHandler(): Exception: " + (Object)((Object)e));
        }
    }

    public static PojoTxSynchronizationHandler getSynchronizationHandler() {
        return (PojoTxSynchronizationHandler)synchronizationHandler_.get();
    }

    public static void reset() {
        synchronizationHandler_.set(null);
    }
}

