/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.collection.CollectionInterceptorUtil;
import org.jboss.cache.pojo.impl.AdvisedPojoHandler;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.CollectionClassHandler;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.ObjectGraphHandler;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoReference;
import org.jboss.cache.pojo.impl.PojoUtil;
import org.jboss.cache.pojo.impl.SerializableObjectHandler;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;
import org.jboss.cache.pojo.interceptors.dynamic.BaseInterceptor;
import org.jboss.cache.pojo.util.AopUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoCacheDelegate {
    private PojoCacheImpl pojoCache;
    private Cache<Object, Object> cache;
    private static final Log log = LogFactory.getLog(PojoCacheDelegate.class);
    private InternalHelper internal_;
    private AdvisedPojoHandler advisedHandler_;
    private ObjectGraphHandler graphHandler_;
    private CollectionClassHandler collectionHandler_;
    private SerializableObjectHandler serializableHandler_;
    private ThreadLocal<Boolean> bulkRemove_ = new ThreadLocal();
    private final String DETACH = "DETACH";
    private PojoUtil util_ = new PojoUtil();

    public PojoCacheDelegate(PojoCacheImpl cache) {
        this.pojoCache = cache;
        this.cache = this.pojoCache.getCache();
        this.internal_ = new InternalHelper(this.cache);
        this.graphHandler_ = new ObjectGraphHandler(this.pojoCache, this.internal_);
        this.collectionHandler_ = new CollectionClassHandler(this.pojoCache, this.internal_);
        this.serializableHandler_ = new SerializableObjectHandler(this.pojoCache, this.internal_);
        this.advisedHandler_ = new AdvisedPojoHandler(this.pojoCache, this.internal_, this.util_);
    }

    public void setBulkRemove(boolean bulk) {
        this.bulkRemove_.set(bulk);
    }

    private boolean getBulkRemove() {
        return this.bulkRemove_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Fqn fqn, String field) throws CacheException {
        Object pojo = this.internal_.getPojo(fqn, field);
        if (pojo != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getObject(): id: " + fqn + " retrieved from existing instance directly. "));
            }
            return pojo;
        }
        ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
        try {
            Region region = this.cache.getRegion(fqn, false);
            if (region != null && region.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(region.getClassLoader());
            }
            Object object = this.getObjectInternal(fqn, field);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCL);
        }
    }

    public Object putObjectI(Fqn fqn, Object obj, String field) throws CacheException {
        Object oldValue = this.internal_.getPojo(fqn, field);
        if (oldValue == obj && (obj instanceof Advised || obj instanceof ClassProxy)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("putObject(): id: " + fqn + " pojo is already in the cache. Return right away."));
            }
            return obj;
        }
        return null;
    }

    public Object putObjectII(Fqn fqn, Object obj, String field) throws CacheException {
        Object oldValue = this.internal_.getPojo(fqn, field);
        if (oldValue == obj) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("putObject(): id: " + fqn + " pojo is already in the cache. Return right away."));
            }
            return obj;
        }
        this.pojoCache.detach(fqn, field);
        if (obj == null) {
            return oldValue;
        }
        if ((obj instanceof Advised || obj instanceof ClassProxy) && this.isMultipleReferencedPut(obj)) {
            this.graphHandler_.put(fqn, obj, field);
        } else {
            Fqn internalFqn = this.createInternalFqn(fqn, obj);
            if (log.isDebugEnabled()) {
                log.debug((Object)("putObject(): id: " + fqn + " will store the pojo in the internal area: " + internalFqn));
            }
            if (obj instanceof Advised) {
                this.advisedHandler_.put(internalFqn, fqn, obj);
            } else if (this.isCollection(obj)) {
                this.collectionHandler_.put(internalFqn, fqn, obj);
            } else {
                this.serializableHandler_.put(internalFqn, obj);
            }
            this.cache.put(internalFqn, (Object)"POJOCache.Status", (Object)"ATTACHED");
            this.setPojoReference(fqn, obj, field, internalFqn);
        }
        return oldValue;
    }

    Fqn createInternalFqn(Fqn fqn, Object obj) throws CacheException {
        return AopUtil.createInternalFqn(fqn, this.cache);
    }

    Fqn setPojoReference(Fqn fqn, Object obj, String field, Fqn internalFqn) throws CacheException {
        CachedType type = this.pojoCache.getCachedType(obj.getClass());
        PojoReference pojoReference = new PojoReference();
        pojoReference.setPojoClass(type.getType());
        pojoReference.setFqn(internalFqn);
        this.internal_.putPojoReference(fqn, pojoReference, field);
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(): inserting PojoReference with id: " + fqn));
        }
        return internalFqn;
    }

    private void createChildNodeFirstWithoutLocking(Fqn internalFqn) {
        int size = internalFqn.size();
        Fqn f = internalFqn.getSubFqn(0, size - 1);
        Fqn child = internalFqn.getSubFqn(size - 1, size);
        Node base = this.cache.getRoot().getChild(f);
        if (base == null) {
            log.debug((Object)("The node retrieved is null from fqn: " + f));
            return;
        }
        base.addChild(child);
    }

    public Object removeObject(Fqn fqn, String field) throws CacheException {
        Object result;
        PojoReference pojoReference = this.internal_.getPojoReference(fqn, field);
        if (pojoReference == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("removeObject(): clazz is null. id: " + fqn + " No need to remove."));
            }
            return null;
        }
        Class clazz = pojoReference.getPojoClass();
        Fqn internalFqn = pojoReference.getFqn();
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeObject(): removing object from id: " + fqn + " with the corresponding internal id: " + internalFqn));
        }
        if ((result = this.pojoCache.getObject(internalFqn)) == null) {
            return null;
        }
        if (this.graphHandler_.isMultipleReferenced(internalFqn)) {
            this.graphHandler_.remove(fqn, internalFqn, result);
        } else {
            this.cache.put(internalFqn, (Object)"POJOCache.Status", (Object)"DETACHING");
            if (Advised.class.isAssignableFrom(clazz)) {
                this.advisedHandler_.remove(internalFqn, result, clazz);
                this.internal_.cleanUp(internalFqn, null);
            } else if (this.isCollectionGet(clazz)) {
                result = this.collectionHandler_.remove(internalFqn, result);
                this.internal_.cleanUp(internalFqn, null);
            } else {
                this.serializableHandler_.remove();
                this.internal_.cleanUp(internalFqn, null);
            }
        }
        this.internal_.cleanUp(fqn, field);
        return result;
    }

    public Map findObjects(Fqn fqn) throws CacheException {
        HashMap<Fqn, Object> map = new HashMap<Fqn, Object>();
        Object pojo = this.getObject(fqn, null);
        if (pojo != null) {
            map.put(fqn, pojo);
            return map;
        }
        this.findChildObjects(fqn, map);
        if (log.isDebugEnabled()) {
            log.debug((Object)("_findObjects(): id: " + fqn + " size of pojos found: " + map.size()));
        }
        return map;
    }

    private Object getObjectInternal(Fqn fqn, String field) throws CacheException {
        PojoInstance pojoInstance;
        Fqn internalFqn = fqn;
        PojoReference pojoReference = this.internal_.getPojoReference(fqn, field);
        if (pojoReference != null) {
            internalFqn = pojoReference.getFqn();
        } else if (field != null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getObject(): id: " + fqn + " with a corresponding internal id: " + internalFqn));
        }
        if ((pojoInstance = this.internal_.getPojoInstance(internalFqn)) == null) {
            return null;
        }
        Class clazz = pojoInstance.getPojoClass();
        Object obj = Advised.class.isAssignableFrom(clazz) ? this.advisedHandler_.get(internalFqn, clazz, pojoInstance) : (this.isCollectionGet(clazz) ? this.collectionHandler_.get(internalFqn, clazz, pojoInstance) : this.serializableHandler_.get(internalFqn, clazz, pojoInstance));
        InternalHelper.setPojo(pojoInstance, obj);
        return obj;
    }

    private boolean isCollectionGet(Class clazz) {
        return Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz);
    }

    private boolean isMultipleReferencedPut(Object obj) {
        AbstractCollectionInterceptor interceptor = null;
        if (obj instanceof Advised) {
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            if (advisor == null) {
                throw new PojoCacheException("_putObject(): InstanceAdvisor is null for: " + obj);
            }
            interceptor = AopUtil.findCacheInterceptor(advisor);
        } else {
            interceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)obj);
        }
        if (interceptor == null) {
            return false;
        }
        Fqn originalFqn = null;
        originalFqn = ((BaseInterceptor)interceptor).getFqn();
        return originalFqn != null;
    }

    private boolean isCollection(Object obj) {
        return obj instanceof Collection || obj instanceof Map;
    }

    private void detachInterceptor(InstanceAdvisor advisor, Interceptor interceptor, boolean detachOnly, Map undoMap) {
        if (!detachOnly) {
            this.util_.detachInterceptor(advisor, interceptor);
            undoMap.put(advisor, interceptor);
        } else {
            undoMap.put("DETACH", interceptor);
        }
    }

    private static void undoInterceptorDetach(Map undoMap) {
        for (Object obj : undoMap.keySet()) {
            if (obj instanceof InstanceAdvisor) {
                InstanceAdvisor advisor = (InstanceAdvisor)obj;
                BaseInterceptor interceptor = (BaseInterceptor)undoMap.get(advisor);
                if (interceptor == null) {
                    throw new IllegalStateException("PojoCacheDelegate.undoInterceptorDetach(): null interceptor");
                }
                advisor.appendInterceptor((Interceptor)interceptor);
                continue;
            }
            BaseInterceptor interceptor = (BaseInterceptor)undoMap.get(obj);
            boolean copyToCache = false;
            ((AbstractCollectionInterceptor)interceptor).attach(null, copyToCache);
        }
    }

    private void findChildObjects(Fqn fqn, Map map) throws CacheException {
        Node root = this.cache.getRoot();
        Node current = root.getChild(fqn);
        if (current == null) {
            return;
        }
        Set col = current.getChildren();
        if (col == null) {
            return;
        }
        for (Node n : col) {
            Fqn newFqn = n.getFqn();
            if (InternalHelper.isInternalNode(newFqn)) continue;
            Object pojo = this.getObject(newFqn, null);
            if (pojo != null) {
                map.put(newFqn, pojo);
                continue;
            }
            this.findChildObjects(newFqn, map);
        }
    }

    public boolean exists(Fqn<?> id) {
        return this.internal_.getPojoReference(id, null) != null || this.internal_.getPojoInstance(id) != null;
    }
}

