/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.collection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.GeneratedAdvisorDomain;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.GeneratedInstanceAdvisorMixin;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.annotation.Reentrant;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;
import org.jboss.cache.pojo.util.CacheApiUtil;
import org.jboss.cache.pojo.util.Null;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reentrant
public class CachedMapImpl
implements Map,
Advised {
    private PojoCacheImpl pojoCache;
    private Cache<Object, Object> cache;
    private AbstractCollectionInterceptor interceptor;
    private static transient Advisor aop$classAdvisor$aop = new CachedMapImplAdvisor();
    protected volatile transient Advisor currentAdvisor$aop = this._getAdvisor();
    protected transient InstanceAdvisor instanceAdvisor$aop;

    public CachedMapImpl(PojoCacheImpl pCache, AbstractCollectionInterceptor interceptor) {
        this.pojoCache = pCache;
        this.cache = this.pojoCache.getCache();
        this.interceptor = interceptor;
    }

    private static Fqn constructFqn(Fqn baseFqn, Object relative) {
        if (!(relative instanceof Serializable) && !(relative instanceof Advised)) {
            throw new PojoCacheException("Non-serializable for " + relative.getClass().getName());
        }
        return new Fqn(baseFqn, new Object[]{relative});
    }

    private Fqn getFqn() {
        return this.interceptor.getFqn();
    }

    private Object attach(Object key, Object value) {
        Fqn fqn = CachedMapImpl.constructFqn(this.getFqn(), Null.toNullKeyObject(key));
        Object o = this.pojoCache.attach(fqn, Null.toNullObject(value));
        this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"PUT");
        return o;
    }

    private Object detach(Object key) {
        Fqn fqn = CachedMapImpl.constructFqn(this.getFqn(), Null.toNullKeyObject(key));
        this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"REMOVE");
        return this.pojoCache.detach(fqn);
    }

    private Set<Node> getNodeChildren() {
        return CacheApiUtil.getNodeChildren(this.cache, this.getFqn());
    }

    public Object get(Object key) {
        return Null.toNullValue(this.pojoCache.getObject(CachedMapImpl.constructFqn(this.getFqn(), Null.toNullKeyObject(key))));
    }

    public Object put(Object key, Object value) {
        return this.attach(key, value);
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        return this.detach(key);
    }

    @Override
    public void clear() {
        ArrayList list = new ArrayList(this.keySet());
        for (int i = 0; i < list.size(); ++i) {
            this.remove(list.get(i));
        }
    }

    @Override
    public int size() {
        Set<Node> children = this.getNodeChildren();
        return children == null ? 0 : children.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        Set<Node> children = this.getNodeChildren();
        if (children == null) {
            return false;
        }
        for (Node n : children) {
            if (!n.getFqn().getLastElement().equals(Null.toNullKeyObject(object))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values().contains(Null.toNullObject(object));
    }

    public Set entrySet() {
        final CachedMapImpl map = this;
        return new AbstractSet(){

            public int size() {
                Set children = CachedMapImpl.this.getNodeChildren();
                return children == null ? 0 : children.size();
            }

            public Iterator iterator() {
                Set children = CachedMapImpl.this.getNodeChildren();
                final Iterator i = children == null ? Collections.EMPTY_LIST.iterator() : children.iterator();
                return new Iterator(){
                    Object lastKey;

                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    public Object next() {
                        this.lastKey = ((Node)i.next()).getFqn().getLastElement();
                        return new Entry(this.lastKey);
                    }

                    public void remove() {
                        map.remove(this.lastKey);
                    }
                };
            }
        };
    }

    public Collection values() {
        final CachedMapImpl map = this;
        return new AbstractCollection(){

            public int size() {
                Set children = CachedMapImpl.this.getNodeChildren();
                return children == null ? 0 : children.size();
            }

            public void clear() {
                map.clear();
            }

            public Iterator iterator() {
                Set children = CachedMapImpl.this.getNodeChildren();
                final Iterator i = children == null ? Collections.EMPTY_LIST.iterator() : children.iterator();
                return new Iterator(){
                    Object lastKey;

                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    public Object next() {
                        Fqn f = ((Node)i.next()).getFqn();
                        this.lastKey = f.getLastElement();
                        return Null.toNullValue(CachedMapImpl.this.pojoCache.getObject(f));
                    }

                    public void remove() {
                        Object key = this.lastKey;
                        if (key != null) {
                            key = Null.toNullKeyValue(key);
                        }
                        map.remove(key);
                    }
                };
            }
        };
    }

    public Set keySet() {
        final CachedMapImpl map = this;
        return new AbstractSet(){

            public int size() {
                Set children = CachedMapImpl.this.getNodeChildren();
                return children == null ? 0 : children.size();
            }

            public Iterator iterator() {
                Set children = CachedMapImpl.this.getNodeChildren();
                final Iterator i = children == null ? Collections.EMPTY_LIST.iterator() : children.iterator();
                return new Iterator(){
                    Object lastKey;

                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    public Object next() {
                        this.lastKey = ((Node)i.next()).getFqn().getLastElement();
                        return Null.toNullKeyValue(this.lastKey);
                    }

                    public void remove() {
                        Object key = this.lastKey;
                        if (key != null) {
                            key = Null.toNullKeyValue(key);
                        }
                        map.remove(key);
                    }
                };
            }
        };
    }

    public int org$jboss$cache$pojo$collection$CachedMapImpl$hashCode$aop() {
        int result = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            result += i.next().hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        for (Entry entry : this.entrySet()) {
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (!(value == null ? map.get(key) != null || !map.containsKey(key) : !value.equals(map.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String org$jboss$cache$pojo$collection$CachedMapImpl$toString$aop() {
        StringBuffer buf = new StringBuffer();
        Set set = this.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[").append(key).append(", ").append(this.get(key)).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public static Advisor _getClassAdvisor() {
        return aop$classAdvisor$aop;
    }

    protected Advisor getCurrentAdvisor$aop() {
        if (this.currentAdvisor$aop == null) {
            this.currentAdvisor$aop = this._getAdvisor();
        }
        return this.currentAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        if (this.instanceAdvisor$aop == null) {
            CachedMapImpl cachedMapImpl = this;
            synchronized (cachedMapImpl) {
                if (this.instanceAdvisor$aop == null) {
                    Advisor advisor;
                    this.currentAdvisor$aop = advisor = ((CachedMapImplAdvisor)aop$classAdvisor$aop).createInstanceAdvisor(this);
                    this.instanceAdvisor$aop = (InstanceAdvisor)advisor;
                }
            }
        }
        return this.instanceAdvisor$aop;
    }

    @Override
    public int hashCode() {
        return ((CachedMapImplAdvisor)this.getCurrentAdvisor$aop()).hashCode2593808613140459179(this);
    }

    public String toString() {
        return ((CachedMapImplAdvisor)this.getCurrentAdvisor$aop()).toString6853976482757027775(this);
    }

    class Entry
    implements Map.Entry {
        Object key;

        public Entry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return Null.toNullValue(this.key);
        }

        public Object getValue() {
            return Null.toNullValue(CachedMapImpl.this.pojoCache.getObject(CachedMapImpl.constructFqn(CachedMapImpl.this.getFqn(), this.key)));
        }

        public Object setValue(Object value) {
            return CachedMapImpl.this.attach(this.key, value);
        }

        public int hashCode() {
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            Object value = this.getValue();
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
        }
    }

    public static class CachedMapImplAdvisor
    extends GeneratedClassAdvisor
    implements Untransformable {
        protected Domain domain;
        protected MethodInfo aop$MethodInfo_hashCode2593808613140459179;
        public JoinPoint_hashCode2593808613140459179 joinpoint_hashCode2593808613140459179;
        protected MethodInfo aop$MethodInfo_toString6853976482757027775;
        public JoinPoint_toString6853976482757027775 joinpoint_toString6853976482757027775;

        public Domain getDomain() {
            return this.domain;
        }

        protected void initialiseMethods() {
            Object var2_1 = null;
            this.aop$MethodInfo_hashCode2593808613140459179 = new MethodInfo(Class.forName("org.jboss.cache.pojo.collection.CachedMapImpl"), 2593808613140459179L, -4425053988540317960L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_hashCode2593808613140459179);
            Object var4_2 = null;
            this.aop$MethodInfo_toString6853976482757027775 = new MethodInfo(Class.forName("org.jboss.cache.pojo.collection.CachedMapImpl"), 6853976482757027775L, -6045222372004295389L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_toString6853976482757027775);
        }

        protected void initialiseConstructors(Collection collection) {
        }

        protected void initialiseConstructions(Collection collection) {
        }

        protected void initialiseFieldReads(Collection collection) {
        }

        protected void initialiseFieldWrites(Collection collection) {
        }

        protected void initialiseCallers() {
        }

        protected void initialise(AspectManager aspectManager, boolean bl) {
            String string = Domain.getDomainName(((Object)((Object)this)).getClass().getDeclaringClass(), (boolean)bl);
            this.domain = new GeneratedAdvisorDomain(aspectManager, string, ((Object)((Object)this)).getClass().getDeclaringClass(), bl);
            this.domain.setInheritsBindings(true);
            super.initialise(((Object)((Object)this)).getClass().getDeclaringClass(), (AspectManager)this.domain);
        }

        public CachedMapImplAdvisor() {
            super("org.jboss.cache.pojo.collection.CachedMapImpl");
            this.initialise(AspectManager.instance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()), false);
        }

        public CachedMapImplAdvisor(CachedMapImplAdvisor cachedMapImplAdvisor) {
            super("org.jboss.cache.pojo.collection.CachedMapImpl", (GeneratedClassAdvisor)cachedMapImplAdvisor);
            this.initialise((AspectManager)cachedMapImplAdvisor.getDomain(), true);
        }

        protected CachedMapImplAdvisor(String string) {
            super(string);
        }

        protected CachedMapImplAdvisor(String string, GeneratedClassAdvisor generatedClassAdvisor) {
            super(string, generatedClassAdvisor);
        }

        public Advisor createInstanceAdvisor(Object object) {
            return new CachedMapImplInstanceAdvisor(object, this);
        }

        protected int hashCode2593808613140459179(CachedMapImpl cachedMapImpl) {
            if (this.joinpoint_hashCode2593808613140459179 == null && this.aop$MethodInfo_hashCode2593808613140459179 != null && this.aop$MethodInfo_hashCode2593808613140459179.hasAdvices()) {
                this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_hashCode2593808613140459179 == null) {
                        if (this.aop$MethodInfo_hashCode2593808613140459179 == null) {
                        } else if (!this.aop$MethodInfo_hashCode2593808613140459179.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_hashCode2593808613140459179);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_hashCode2593808613140459179 == null) {
                return cachedMapImpl.org$jboss$cache$pojo$collection$CachedMapImpl$hashCode$aop();
            }
            return this.joinpoint_hashCode2593808613140459179.invokeJoinpoint(cachedMapImpl);
        }

        protected String toString6853976482757027775(CachedMapImpl cachedMapImpl) {
            if (this.joinpoint_toString6853976482757027775 == null && this.aop$MethodInfo_toString6853976482757027775 != null && this.aop$MethodInfo_toString6853976482757027775.hasAdvices()) {
                this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_toString6853976482757027775 == null) {
                        if (this.aop$MethodInfo_toString6853976482757027775 == null) {
                        } else if (!this.aop$MethodInfo_toString6853976482757027775.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_toString6853976482757027775);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_toString6853976482757027775 == null) {
                return cachedMapImpl.org$jboss$cache$pojo$collection$CachedMapImpl$toString$aop();
            }
            return this.joinpoint_toString6853976482757027775.invokeJoinpoint(cachedMapImpl);
        }
    }

    public static class CachedMapImplInstanceAdvisor
    extends CachedMapImplAdvisor
    implements Untransformable,
    InstanceAdvisor {
        GeneratedInstanceAdvisorMixin instanceAdvisorMixin;
        CachedMapImplAdvisor parent = null;
        protected boolean aop$MethodInfo_hashCode2593808613140459179_updated;
        protected boolean aop$MethodInfo_toString6853976482757027775_updated;

        protected void advicesUpdated() {
            Object var2_1 = null;
            this.aop$MethodInfo_hashCode2593808613140459179_updated = true;
            this.aop$MethodInfo_toString6853976482757027775_updated = true;
        }

        protected void lockWriteInterceptorChains() {
            Object var2_1 = null;
            this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().lock();
            this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().lock();
        }

        protected void unlockWriteInterceptorChains() {
            Object var2_1 = null;
            this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().unlock();
            this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().unlock();
        }

        public SimpleMetaData getMetaData() {
            return this.instanceAdvisorMixin.getMetaData();
        }

        public Object getInstance() {
            return this.instanceAdvisorMixin.getInstance();
        }

        public boolean hasInterceptors() {
            return this.instanceAdvisorMixin.hasInterceptors();
        }

        public void insertInterceptor(Interceptor interceptor) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptor(interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void insertInterceptor(int n, Interceptor interceptor) throws IndexOutOfBoundsException {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptor(n, interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void insertInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptor(Interceptor interceptor) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptor(interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptor(int n, Interceptor interceptor) throws IndexOutOfBoundsException {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptor(n, interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void removeInterceptor(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.removeInterceptor(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void removeInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.removeInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public Interceptor[] getInterceptors() {
            return this.instanceAdvisorMixin.getInterceptors();
        }

        public Interceptor[] getInterceptors(Interceptor[] interceptorArray) {
            return this.instanceAdvisorMixin.getInterceptors(interceptorArray);
        }

        public Object getPerInstanceAspect(String string) {
            return this.instanceAdvisorMixin.getPerInstanceAspect(string);
        }

        public Object getPerInstanceAspect(AspectDefinition aspectDefinition) {
            return this.instanceAdvisorMixin.getPerInstanceAspect(aspectDefinition);
        }

        public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition aspectDefinition) {
            return this.instanceAdvisorMixin.getPerInstanceJoinpointAspect(joinpoint, aspectDefinition);
        }

        protected void doRebuildForInstance() {
            this.lockWriteInterceptorChains();
            try {
                this.internalRebuildInterceptors();
                if (this.instanceAdvisorMixin.hasInterceptors()) {
                    this.advicesUpdated();
                }
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public CachedMapImplInstanceAdvisor(Object object, CachedMapImplAdvisor cachedMapImplAdvisor) {
            super(cachedMapImplAdvisor);
            this.instanceAdvisorMixin = new GeneratedInstanceAdvisorMixin(object, (GeneratedClassAdvisor)cachedMapImplAdvisor);
            this.parent = cachedMapImplAdvisor;
        }

        protected void initialiseInfosForInstance() {
            Object var2_1 = null;
            CachedMapImplAdvisor cachedMapImplAdvisor = (CachedMapImplAdvisor)CachedMapImpl._getClassAdvisor();
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.aop$MethodInfo_hashCode2593808613140459179 = super.copyInfoFromClassAdvisor(((CachedMapImplAdvisor)CachedMapImpl._getClassAdvisor()).aop$MethodInfo_hashCode2593808613140459179);
            this.aop$MethodInfo_toString6853976482757027775 = super.copyInfoFromClassAdvisor(((CachedMapImplAdvisor)CachedMapImpl._getClassAdvisor()).aop$MethodInfo_toString6853976482757027775);
            ((ClassAdvisor)this).fieldReadInfos = arrayList.toArray(new FieldInfo[arrayList.size()]);
            ((ClassAdvisor)this).fieldWriteInfos = arrayList2.toArray(new FieldInfo[arrayList2.size()]);
        }

        protected int hashCode2593808613140459179(CachedMapImpl cachedMapImpl) {
            this.checkVersion();
            if (this.aop$MethodInfo_hashCode2593808613140459179_updated) {
                this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_hashCode2593808613140459179.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_hashCode2593808613140459179.getInterceptors()));
                    this.joinpoint_hashCode2593808613140459179 = null;
                    this.aop$MethodInfo_hashCode2593808613140459179_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_hashCode2593808613140459179);
                }
                finally {
                    this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.hashCode2593808613140459179(cachedMapImpl);
        }

        protected String toString6853976482757027775(CachedMapImpl cachedMapImpl) {
            this.checkVersion();
            if (this.aop$MethodInfo_toString6853976482757027775_updated) {
                this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_toString6853976482757027775.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_toString6853976482757027775.getInterceptors()));
                    this.joinpoint_toString6853976482757027775 = null;
                    this.aop$MethodInfo_toString6853976482757027775_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_toString6853976482757027775);
                }
                finally {
                    this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.toString6853976482757027775(cachedMapImpl);
        }
    }

    public static class JoinPoint_hashCode2593808613140459179
    extends MethodInvocation
    implements Untransformable {
        protected transient CachedMapImpl typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        protected int invokeJoinpoint(CachedMapImpl cachedMapImpl) throws Throwable {
            return 0;
        }

        public JoinPoint_hashCode2593808613140459179() {
        }

        public JoinPoint_hashCode2593808613140459179(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_hashCode2593808613140459179(JoinPoint_hashCode2593808613140459179 joinPoint_hashCode2593808613140459179, CachedMapImpl cachedMapImpl) {
            this(joinPoint_hashCode2593808613140459179.info);
            this.typedTargetObject = cachedMapImpl;
            super.setTargetObject((Object)cachedMapImpl);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return new Integer(this.typedTargetObject.org$jboss$cache$pojo$collection$CachedMapImpl$hashCode$aop());
        }

        protected int dispatch(CachedMapImpl cachedMapImpl) {
            return cachedMapImpl.org$jboss$cache$pojo$collection$CachedMapImpl$hashCode$aop();
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }

    public static class JoinPoint_toString6853976482757027775
    extends MethodInvocation
    implements Untransformable {
        protected transient CachedMapImpl typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        protected String invokeJoinpoint(CachedMapImpl cachedMapImpl) throws Throwable {
            return null;
        }

        public JoinPoint_toString6853976482757027775() {
        }

        public JoinPoint_toString6853976482757027775(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_toString6853976482757027775(JoinPoint_toString6853976482757027775 joinPoint_toString6853976482757027775, CachedMapImpl cachedMapImpl) {
            this(joinPoint_toString6853976482757027775.info);
            this.typedTargetObject = cachedMapImpl;
            super.setTargetObject((Object)cachedMapImpl);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$cache$pojo$collection$CachedMapImpl$toString$aop();
        }

        protected String dispatch(CachedMapImpl cachedMapImpl) {
            return cachedMapImpl.org$jboss$cache$pojo$collection$CachedMapImpl$toString$aop();
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }
}

