/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.GeneratedAdvisorDomain;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.GeneratedInstanceAdvisorMixin;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Version;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.annotation.Attach;
import org.jboss.cache.pojo.annotation.Detach;
import org.jboss.cache.pojo.annotation.Find;
import org.jboss.cache.pojo.impl.CacheListenerAdaptor;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.PojoCacheDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoCacheImpl
implements PojoCache,
Advised {
    private CacheSPI<Object, Object> cache = null;
    protected final Log log_;
    private PojoCacheDelegate delegate_;
    private Map cachedTypes_;
    private boolean hasCreate_ = false;
    private CacheListenerAdaptor listenerAdaptor;
    private static transient Advisor aop$classAdvisor$aop = new PojoCacheImplAdvisor();
    protected volatile transient Advisor currentAdvisor$aop = this._getAdvisor();
    protected transient InstanceAdvisor instanceAdvisor$aop;

    public PojoCacheImpl(String configStr, boolean toStart) {
        this.log_ = LogFactory.getLog(this.getClass());
        this.cachedTypes_ = new WeakHashMap();
        this.listenerAdaptor = new CacheListenerAdaptor(this);
        try {
            XmlConfigurationParser parser = new XmlConfigurationParser();
            Configuration expected = parser.parseFile(configStr);
            this.init(expected, toStart);
        }
        catch (Exception e) {
            throw new PojoCacheException("Failed to start " + configStr, e);
        }
    }

    public PojoCacheImpl(Configuration config, boolean toStart) {
        this.log_ = LogFactory.getLog(this.getClass());
        this.cachedTypes_ = new WeakHashMap();
        this.listenerAdaptor = new CacheListenerAdaptor(this);
        this.init(config, toStart);
    }

    private void init(Configuration config, boolean toStart) {
        try {
            this.cache = (CacheSPI)DefaultCacheFactory.getInstance().createCache(config, toStart);
        }
        catch (Exception e) {
            throw new PojoCacheException("init " + config + " failed", e);
        }
        this.delegate_ = new PojoCacheDelegate(this);
    }

    public CacheSPI<Object, Object> getCacheSPI() {
        return this.cache;
    }

    @Override
    public Object attach(String id, Object pojo) throws PojoCacheException {
        return this.attach(Fqn.fromString((String)id), pojo);
    }

    public Object org$jboss$cache$pojo$impl$PojoCacheImpl$attach$aop(Fqn<?> id, Object pojo) throws PojoCacheException {
        try {
            Object obj = this.putObject(id, pojo, null);
            return obj;
        }
        catch (CacheException e) {
            throw new PojoCacheException("putObject failed " + id, e);
        }
    }

    public Object org$jboss$cache$pojo$impl$PojoCacheImpl$attach$aop(Fqn<?> id, Object pojo, String field) throws PojoCacheException {
        try {
            Object obj = this.putObject(id, pojo, field);
            return obj;
        }
        catch (CacheException e) {
            throw new PojoCacheException("putObject failed " + id, e);
        }
    }

    public Object putObject(Fqn<?> id, Object pojo, String field) throws CacheException {
        Object obj = null;
        obj = this.delegate_.putObjectI(id, pojo, field);
        if (obj != null) {
            return obj;
        }
        obj = this.delegate_.putObjectII(id, pojo, field);
        return obj;
    }

    @Override
    public Object detach(String id) throws PojoCacheException {
        return this.detach(Fqn.fromString((String)id));
    }

    public Object org$jboss$cache$pojo$impl$PojoCacheImpl$detach$aop(Fqn<?> id, String field) throws PojoCacheException {
        try {
            Object pojo = this.getObject(id, field);
            if (pojo == null) {
                return pojo;
            }
            Object obj = this.removeObject(id, field);
            return obj;
        }
        catch (CacheException e) {
            throw new PojoCacheException("detach " + id + " failed", e);
        }
    }

    @Override
    public Object detach(Fqn<?> id) throws PojoCacheException {
        return this.detach(id, null);
    }

    public Object removeObject(Fqn<?> id, String field) throws CacheException {
        this.delegate_.setBulkRemove(false);
        return this.delegate_.removeObject(id, field);
    }

    @Override
    public String getPojoID(Object pojo) {
        throw new PojoCacheException("getPojoID not yet implemented");
    }

    @Override
    public boolean exists(Fqn<?> id) {
        return this.delegate_.exists(id);
    }

    @Override
    public Object find(String id) throws PojoCacheException {
        return this.find(Fqn.fromString((String)id));
    }

    public Object org$jboss$cache$pojo$impl$PojoCacheImpl$find$aop(Fqn<?> id) throws PojoCacheException {
        try {
            return this.getObject(id);
        }
        catch (CacheException e) {
            throw new PojoCacheException("find " + id + " failed ", e);
        }
    }

    public Object getObject(Fqn<?> id) throws CacheException {
        return this.getObject(id, null);
    }

    public Object getObject(Fqn<?> id, String field) throws CacheException {
        return this.delegate_.getObject(id, field);
    }

    @Override
    public Map<Fqn<?>, Object> findAll(String id) throws PojoCacheException {
        return this.findAll(Fqn.fromString((String)id));
    }

    public Map<Fqn<?>, Object> org$jboss$cache$pojo$impl$PojoCacheImpl$findAll$aop(Fqn<?> id) throws PojoCacheException {
        if (id == null) {
            id = Fqn.ROOT;
        }
        try {
            return this.delegate_.findObjects(id);
        }
        catch (CacheException e) {
            throw new PojoCacheException("findAll " + id + " failed", e);
        }
    }

    public String getVersion() {
        return Version.printVersion();
    }

    @Override
    public void create() throws PojoCacheException {
        this.log_.info((Object)("PojoCache version: " + this.getVersion()));
        try {
            this.cache.create();
        }
        catch (Exception e) {
            throw new PojoCacheException("PojoCache create exception", e);
        }
        this.hasCreate_ = true;
    }

    @Override
    public void start() throws PojoCacheException {
        if (!this.hasCreate_) {
            this.create();
        }
        try {
            this.log_.info((Object)("PojoCache version: " + this.getVersion()));
            this.cache.start();
        }
        catch (Exception e) {
            throw new PojoCacheException("Failed starting " + e, e);
        }
    }

    @Override
    public void stop() throws PojoCacheException {
        this.cache.stop();
    }

    @Override
    public void destroy() throws PojoCacheException {
        this.cache.destroy();
    }

    @Override
    public Collection<Object> getListeners() {
        return this.listenerAdaptor.getListeners();
    }

    @Override
    public void addListener(Object listener) {
        this.addListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Object listener, Pattern pattern) {
        CacheListenerAdaptor cacheListenerAdaptor = this.listenerAdaptor;
        synchronized (cacheListenerAdaptor) {
            try {
                this.listenerAdaptor.addListener(listener, pattern);
            }
            catch (IllegalArgumentException e) {
                e.fillInStackTrace();
                throw e;
            }
            this.cache.addCacheListener((Object)this.listenerAdaptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object listener) {
        CacheListenerAdaptor cacheListenerAdaptor = this.listenerAdaptor;
        synchronized (cacheListenerAdaptor) {
            this.listenerAdaptor.removeListener(listener);
            if (this.listenerAdaptor.isEmpty()) {
                this.cache.removeCacheListener((Object)this.listenerAdaptor);
            }
        }
    }

    @Override
    public Cache<Object, Object> getCache() {
        return this.cache;
    }

    public synchronized CachedType getCachedType(Class clazz) {
        CachedType type = (CachedType)this.cachedTypes_.get(clazz);
        if (type == null) {
            type = new CachedType(clazz);
            this.cachedTypes_.put(clazz, type);
            return type;
        }
        return type;
    }

    public String toString() {
        return this.getClass().getName() + " cache=" + this.cache + " delegate=" + this.delegate_ + " types=" + this.cachedTypes_.size();
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public static Advisor _getClassAdvisor() {
        return aop$classAdvisor$aop;
    }

    protected Advisor getCurrentAdvisor$aop() {
        if (this.currentAdvisor$aop == null) {
            this.currentAdvisor$aop = this._getAdvisor();
        }
        return this.currentAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        if (this.instanceAdvisor$aop == null) {
            PojoCacheImpl pojoCacheImpl = this;
            synchronized (pojoCacheImpl) {
                if (this.instanceAdvisor$aop == null) {
                    Advisor advisor;
                    this.currentAdvisor$aop = advisor = ((PojoCacheImplAdvisor)aop$classAdvisor$aop).createInstanceAdvisor(this);
                    this.instanceAdvisor$aop = (InstanceAdvisor)advisor;
                }
            }
        }
        return this.instanceAdvisor$aop;
    }

    @Override
    @Attach
    public Object attach(Fqn<?> fqn, Object object) throws PojoCacheException {
        return ((PojoCacheImplAdvisor)this.getCurrentAdvisor$aop()).attach3085019539260813833(this, fqn, object);
    }

    @Attach
    public Object attach(Fqn<?> fqn, Object object, String string) throws PojoCacheException {
        return ((PojoCacheImplAdvisor)this.getCurrentAdvisor$aop()).attach_N_6020276434135444173(this, fqn, object, string);
    }

    @Detach
    public Object detach(Fqn<?> fqn, String string) throws PojoCacheException {
        return ((PojoCacheImplAdvisor)this.getCurrentAdvisor$aop()).detach_N_6302035201148273652(this, fqn, string);
    }

    @Override
    @Find
    public Object find(Fqn<?> fqn) throws PojoCacheException {
        return ((PojoCacheImplAdvisor)this.getCurrentAdvisor$aop()).find_N_7063709169143275953(this, fqn);
    }

    @Override
    @Find
    public Map<Fqn<?>, Object> findAll(Fqn<?> fqn) throws PojoCacheException {
        return ((PojoCacheImplAdvisor)this.getCurrentAdvisor$aop()).findAll8569763146126551603(this, fqn);
    }

    public static class PojoCacheImplAdvisor
    extends GeneratedClassAdvisor
    implements Untransformable {
        protected Domain domain;
        protected MethodInfo aop$MethodInfo_attach3085019539260813833;
        public JoinPoint_attach3085019539260813833 joinpoint_attach3085019539260813833;
        protected MethodInfo aop$MethodInfo_attach_N_6020276434135444173;
        public JoinPoint_attach_N_6020276434135444173 joinpoint_attach_N_6020276434135444173;
        protected MethodInfo aop$MethodInfo_detach_N_6302035201148273652;
        public JoinPoint_detach_N_6302035201148273652 joinpoint_detach_N_6302035201148273652;
        protected MethodInfo aop$MethodInfo_find_N_7063709169143275953;
        public JoinPoint_find_N_7063709169143275953 joinpoint_find_N_7063709169143275953;
        protected MethodInfo aop$MethodInfo_findAll8569763146126551603;
        public JoinPoint_findAll8569763146126551603 joinpoint_findAll8569763146126551603;

        public Domain getDomain() {
            return this.domain;
        }

        protected void initialiseMethods() {
            Object var2_1 = null;
            this.aop$MethodInfo_attach3085019539260813833 = new MethodInfo(Class.forName("org.jboss.cache.pojo.impl.PojoCacheImpl"), 3085019539260813833L, -5091723194798265128L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_attach3085019539260813833);
            Object var4_2 = null;
            this.aop$MethodInfo_attach_N_6020276434135444173 = new MethodInfo(Class.forName("org.jboss.cache.pojo.impl.PojoCacheImpl"), -6020276434135444173L, -7081954679016608542L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_attach_N_6020276434135444173);
            Object var6_3 = null;
            this.aop$MethodInfo_detach_N_6302035201148273652 = new MethodInfo(Class.forName("org.jboss.cache.pojo.impl.PojoCacheImpl"), -6302035201148273652L, 6869652354932396382L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_detach_N_6302035201148273652);
            Object var8_4 = null;
            this.aop$MethodInfo_find_N_7063709169143275953 = new MethodInfo(Class.forName("org.jboss.cache.pojo.impl.PojoCacheImpl"), -7063709169143275953L, 8056147675691552120L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_find_N_7063709169143275953);
            Object var10_5 = null;
            this.aop$MethodInfo_findAll8569763146126551603 = new MethodInfo(Class.forName("org.jboss.cache.pojo.impl.PojoCacheImpl"), 8569763146126551603L, 2966465851514771454L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_findAll8569763146126551603);
        }

        protected void initialiseConstructors(Collection collection) {
        }

        protected void initialiseConstructions(Collection collection) {
        }

        protected void initialiseFieldReads(Collection collection) {
        }

        protected void initialiseFieldWrites(Collection collection) {
        }

        protected void initialiseCallers() {
        }

        protected void initialise(AspectManager aspectManager, boolean bl) {
            String string = Domain.getDomainName(((Object)((Object)this)).getClass().getDeclaringClass(), (boolean)bl);
            this.domain = new GeneratedAdvisorDomain(aspectManager, string, ((Object)((Object)this)).getClass().getDeclaringClass(), bl);
            this.domain.setInheritsBindings(true);
            super.initialise(((Object)((Object)this)).getClass().getDeclaringClass(), (AspectManager)this.domain);
        }

        public PojoCacheImplAdvisor() {
            super("org.jboss.cache.pojo.impl.PojoCacheImpl");
            this.initialise(AspectManager.instance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()), false);
        }

        public PojoCacheImplAdvisor(PojoCacheImplAdvisor pojoCacheImplAdvisor) {
            super("org.jboss.cache.pojo.impl.PojoCacheImpl", (GeneratedClassAdvisor)pojoCacheImplAdvisor);
            this.initialise((AspectManager)pojoCacheImplAdvisor.getDomain(), true);
        }

        protected PojoCacheImplAdvisor(String string) {
            super(string);
        }

        protected PojoCacheImplAdvisor(String string, GeneratedClassAdvisor generatedClassAdvisor) {
            super(string, generatedClassAdvisor);
        }

        public Advisor createInstanceAdvisor(Object object) {
            return new PojoCacheImplInstanceAdvisor(object, this);
        }

        protected Object attach3085019539260813833(PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object) throws PojoCacheException {
            if (this.joinpoint_attach3085019539260813833 == null && this.aop$MethodInfo_attach3085019539260813833 != null && this.aop$MethodInfo_attach3085019539260813833.hasAdvices()) {
                this.aop$MethodInfo_attach3085019539260813833.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_attach3085019539260813833 == null) {
                        if (this.aop$MethodInfo_attach3085019539260813833 == null) {
                        } else if (!this.aop$MethodInfo_attach3085019539260813833.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_attach3085019539260813833);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_attach3085019539260813833.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_attach3085019539260813833 == null) {
                return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$attach$aop(fqn, object);
            }
            return this.joinpoint_attach3085019539260813833.invokeJoinpoint(pojoCacheImpl, fqn, object);
        }

        protected Object attach_N_6020276434135444173(PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object, String string) throws PojoCacheException {
            if (this.joinpoint_attach_N_6020276434135444173 == null && this.aop$MethodInfo_attach_N_6020276434135444173 != null && this.aop$MethodInfo_attach_N_6020276434135444173.hasAdvices()) {
                this.aop$MethodInfo_attach_N_6020276434135444173.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_attach_N_6020276434135444173 == null) {
                        if (this.aop$MethodInfo_attach_N_6020276434135444173 == null) {
                        } else if (!this.aop$MethodInfo_attach_N_6020276434135444173.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_attach_N_6020276434135444173);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_attach_N_6020276434135444173.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_attach_N_6020276434135444173 == null) {
                return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$attach$aop(fqn, object, string);
            }
            return this.joinpoint_attach_N_6020276434135444173.invokeJoinpoint(pojoCacheImpl, fqn, object, string);
        }

        protected Object detach_N_6302035201148273652(PojoCacheImpl pojoCacheImpl, Fqn fqn, String string) throws PojoCacheException {
            if (this.joinpoint_detach_N_6302035201148273652 == null && this.aop$MethodInfo_detach_N_6302035201148273652 != null && this.aop$MethodInfo_detach_N_6302035201148273652.hasAdvices()) {
                this.aop$MethodInfo_detach_N_6302035201148273652.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_detach_N_6302035201148273652 == null) {
                        if (this.aop$MethodInfo_detach_N_6302035201148273652 == null) {
                        } else if (!this.aop$MethodInfo_detach_N_6302035201148273652.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_detach_N_6302035201148273652);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_detach_N_6302035201148273652.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_detach_N_6302035201148273652 == null) {
                return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$detach$aop(fqn, string);
            }
            return this.joinpoint_detach_N_6302035201148273652.invokeJoinpoint(pojoCacheImpl, fqn, string);
        }

        protected Object find_N_7063709169143275953(PojoCacheImpl pojoCacheImpl, Fqn fqn) throws PojoCacheException {
            if (this.joinpoint_find_N_7063709169143275953 == null && this.aop$MethodInfo_find_N_7063709169143275953 != null && this.aop$MethodInfo_find_N_7063709169143275953.hasAdvices()) {
                this.aop$MethodInfo_find_N_7063709169143275953.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_find_N_7063709169143275953 == null) {
                        if (this.aop$MethodInfo_find_N_7063709169143275953 == null) {
                        } else if (!this.aop$MethodInfo_find_N_7063709169143275953.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_find_N_7063709169143275953);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_find_N_7063709169143275953.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_find_N_7063709169143275953 == null) {
                return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$find$aop(fqn);
            }
            return this.joinpoint_find_N_7063709169143275953.invokeJoinpoint(pojoCacheImpl, fqn);
        }

        protected Map findAll8569763146126551603(PojoCacheImpl pojoCacheImpl, Fqn fqn) throws PojoCacheException {
            if (this.joinpoint_findAll8569763146126551603 == null && this.aop$MethodInfo_findAll8569763146126551603 != null && this.aop$MethodInfo_findAll8569763146126551603.hasAdvices()) {
                this.aop$MethodInfo_findAll8569763146126551603.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_findAll8569763146126551603 == null) {
                        if (this.aop$MethodInfo_findAll8569763146126551603 == null) {
                        } else if (!this.aop$MethodInfo_findAll8569763146126551603.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_findAll8569763146126551603);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_findAll8569763146126551603.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_findAll8569763146126551603 == null) {
                return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$findAll$aop(fqn);
            }
            return this.joinpoint_findAll8569763146126551603.invokeJoinpoint(pojoCacheImpl, fqn);
        }
    }

    public static class PojoCacheImplInstanceAdvisor
    extends PojoCacheImplAdvisor
    implements Untransformable,
    InstanceAdvisor {
        GeneratedInstanceAdvisorMixin instanceAdvisorMixin;
        PojoCacheImplAdvisor parent = null;
        protected boolean aop$MethodInfo_attach3085019539260813833_updated;
        protected boolean aop$MethodInfo_attach_N_6020276434135444173_updated;
        protected boolean aop$MethodInfo_detach_N_6302035201148273652_updated;
        protected boolean aop$MethodInfo_find_N_7063709169143275953_updated;
        protected boolean aop$MethodInfo_findAll8569763146126551603_updated;

        protected void advicesUpdated() {
            Object var2_1 = null;
            this.aop$MethodInfo_attach3085019539260813833_updated = true;
            this.aop$MethodInfo_attach_N_6020276434135444173_updated = true;
            this.aop$MethodInfo_detach_N_6302035201148273652_updated = true;
            this.aop$MethodInfo_find_N_7063709169143275953_updated = true;
            this.aop$MethodInfo_findAll8569763146126551603_updated = true;
        }

        protected void lockWriteInterceptorChains() {
            Object var2_1 = null;
            this.aop$MethodInfo_attach3085019539260813833.getInterceptorChainReadWriteLock().writeLock().lock();
            this.aop$MethodInfo_attach_N_6020276434135444173.getInterceptorChainReadWriteLock().writeLock().lock();
            this.aop$MethodInfo_detach_N_6302035201148273652.getInterceptorChainReadWriteLock().writeLock().lock();
            this.aop$MethodInfo_find_N_7063709169143275953.getInterceptorChainReadWriteLock().writeLock().lock();
            this.aop$MethodInfo_findAll8569763146126551603.getInterceptorChainReadWriteLock().writeLock().lock();
        }

        protected void unlockWriteInterceptorChains() {
            Object var2_1 = null;
            this.aop$MethodInfo_attach3085019539260813833.getInterceptorChainReadWriteLock().writeLock().unlock();
            this.aop$MethodInfo_attach_N_6020276434135444173.getInterceptorChainReadWriteLock().writeLock().unlock();
            this.aop$MethodInfo_detach_N_6302035201148273652.getInterceptorChainReadWriteLock().writeLock().unlock();
            this.aop$MethodInfo_find_N_7063709169143275953.getInterceptorChainReadWriteLock().writeLock().unlock();
            this.aop$MethodInfo_findAll8569763146126551603.getInterceptorChainReadWriteLock().writeLock().unlock();
        }

        public SimpleMetaData getMetaData() {
            return this.instanceAdvisorMixin.getMetaData();
        }

        public Object getInstance() {
            return this.instanceAdvisorMixin.getInstance();
        }

        public boolean hasInterceptors() {
            return this.instanceAdvisorMixin.hasInterceptors();
        }

        public void insertInterceptor(Interceptor interceptor) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptor(interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void insertInterceptor(int n, Interceptor interceptor) throws IndexOutOfBoundsException {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptor(n, interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void insertInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptor(Interceptor interceptor) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptor(interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptor(int n, Interceptor interceptor) throws IndexOutOfBoundsException {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptor(n, interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void removeInterceptor(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.removeInterceptor(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void removeInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.removeInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public Interceptor[] getInterceptors() {
            return this.instanceAdvisorMixin.getInterceptors();
        }

        public Interceptor[] getInterceptors(Interceptor[] interceptorArray) {
            return this.instanceAdvisorMixin.getInterceptors(interceptorArray);
        }

        public Object getPerInstanceAspect(String string) {
            return this.instanceAdvisorMixin.getPerInstanceAspect(string);
        }

        public Object getPerInstanceAspect(AspectDefinition aspectDefinition) {
            return this.instanceAdvisorMixin.getPerInstanceAspect(aspectDefinition);
        }

        public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition aspectDefinition) {
            return this.instanceAdvisorMixin.getPerInstanceJoinpointAspect(joinpoint, aspectDefinition);
        }

        protected void doRebuildForInstance() {
            this.lockWriteInterceptorChains();
            try {
                this.internalRebuildInterceptors();
                if (this.instanceAdvisorMixin.hasInterceptors()) {
                    this.advicesUpdated();
                }
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public PojoCacheImplInstanceAdvisor(Object object, PojoCacheImplAdvisor pojoCacheImplAdvisor) {
            super(pojoCacheImplAdvisor);
            this.instanceAdvisorMixin = new GeneratedInstanceAdvisorMixin(object, (GeneratedClassAdvisor)pojoCacheImplAdvisor);
            this.parent = pojoCacheImplAdvisor;
        }

        protected void initialiseInfosForInstance() {
            Object var2_1 = null;
            PojoCacheImplAdvisor pojoCacheImplAdvisor = (PojoCacheImplAdvisor)PojoCacheImpl._getClassAdvisor();
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.aop$MethodInfo_attach3085019539260813833 = super.copyInfoFromClassAdvisor(((PojoCacheImplAdvisor)PojoCacheImpl._getClassAdvisor()).aop$MethodInfo_attach3085019539260813833);
            this.aop$MethodInfo_attach_N_6020276434135444173 = super.copyInfoFromClassAdvisor(((PojoCacheImplAdvisor)PojoCacheImpl._getClassAdvisor()).aop$MethodInfo_attach_N_6020276434135444173);
            this.aop$MethodInfo_detach_N_6302035201148273652 = super.copyInfoFromClassAdvisor(((PojoCacheImplAdvisor)PojoCacheImpl._getClassAdvisor()).aop$MethodInfo_detach_N_6302035201148273652);
            this.aop$MethodInfo_find_N_7063709169143275953 = super.copyInfoFromClassAdvisor(((PojoCacheImplAdvisor)PojoCacheImpl._getClassAdvisor()).aop$MethodInfo_find_N_7063709169143275953);
            this.aop$MethodInfo_findAll8569763146126551603 = super.copyInfoFromClassAdvisor(((PojoCacheImplAdvisor)PojoCacheImpl._getClassAdvisor()).aop$MethodInfo_findAll8569763146126551603);
            ((ClassAdvisor)this).fieldReadInfos = arrayList.toArray(new FieldInfo[arrayList.size()]);
            ((ClassAdvisor)this).fieldWriteInfos = arrayList2.toArray(new FieldInfo[arrayList2.size()]);
        }

        protected Object attach3085019539260813833(PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object) throws PojoCacheException {
            this.checkVersion();
            if (this.aop$MethodInfo_attach3085019539260813833_updated) {
                this.aop$MethodInfo_attach3085019539260813833.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_attach3085019539260813833.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_attach3085019539260813833.getInterceptors()));
                    this.joinpoint_attach3085019539260813833 = null;
                    this.aop$MethodInfo_attach3085019539260813833_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_attach3085019539260813833);
                }
                finally {
                    this.aop$MethodInfo_attach3085019539260813833.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.attach3085019539260813833(pojoCacheImpl, fqn, object);
        }

        protected Object attach_N_6020276434135444173(PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object, String string) throws PojoCacheException {
            this.checkVersion();
            if (this.aop$MethodInfo_attach_N_6020276434135444173_updated) {
                this.aop$MethodInfo_attach_N_6020276434135444173.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_attach_N_6020276434135444173.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_attach_N_6020276434135444173.getInterceptors()));
                    this.joinpoint_attach_N_6020276434135444173 = null;
                    this.aop$MethodInfo_attach_N_6020276434135444173_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_attach_N_6020276434135444173);
                }
                finally {
                    this.aop$MethodInfo_attach_N_6020276434135444173.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.attach_N_6020276434135444173(pojoCacheImpl, fqn, object, string);
        }

        protected Object detach_N_6302035201148273652(PojoCacheImpl pojoCacheImpl, Fqn fqn, String string) throws PojoCacheException {
            this.checkVersion();
            if (this.aop$MethodInfo_detach_N_6302035201148273652_updated) {
                this.aop$MethodInfo_detach_N_6302035201148273652.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_detach_N_6302035201148273652.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_detach_N_6302035201148273652.getInterceptors()));
                    this.joinpoint_detach_N_6302035201148273652 = null;
                    this.aop$MethodInfo_detach_N_6302035201148273652_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_detach_N_6302035201148273652);
                }
                finally {
                    this.aop$MethodInfo_detach_N_6302035201148273652.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.detach_N_6302035201148273652(pojoCacheImpl, fqn, string);
        }

        protected Object find_N_7063709169143275953(PojoCacheImpl pojoCacheImpl, Fqn fqn) throws PojoCacheException {
            this.checkVersion();
            if (this.aop$MethodInfo_find_N_7063709169143275953_updated) {
                this.aop$MethodInfo_find_N_7063709169143275953.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_find_N_7063709169143275953.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_find_N_7063709169143275953.getInterceptors()));
                    this.joinpoint_find_N_7063709169143275953 = null;
                    this.aop$MethodInfo_find_N_7063709169143275953_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_find_N_7063709169143275953);
                }
                finally {
                    this.aop$MethodInfo_find_N_7063709169143275953.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.find_N_7063709169143275953(pojoCacheImpl, fqn);
        }

        protected Map findAll8569763146126551603(PojoCacheImpl pojoCacheImpl, Fqn fqn) throws PojoCacheException {
            this.checkVersion();
            if (this.aop$MethodInfo_findAll8569763146126551603_updated) {
                this.aop$MethodInfo_findAll8569763146126551603.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_findAll8569763146126551603.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_findAll8569763146126551603.getInterceptors()));
                    this.joinpoint_findAll8569763146126551603 = null;
                    this.aop$MethodInfo_findAll8569763146126551603_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_findAll8569763146126551603);
                }
                finally {
                    this.aop$MethodInfo_findAll8569763146126551603.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.findAll8569763146126551603(pojoCacheImpl, fqn);
        }
    }

    public static class JoinPoint_attach3085019539260813833
    extends MethodInvocation
    implements Untransformable {
        boolean inconsistentArgs = false;
        public Fqn arg0;
        public Object arg1;
        protected transient PojoCacheImpl typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            this.inconsistentArgs = true;
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public void setArguments(Object[] objectArray) {
            this.inconsistentArgs = true;
            this.arguments = objectArray;
        }

        final void enforceArgsConsistency() {
            if (this.inconsistentArgs) {
                this.arg0 = (Fqn)this.arguments[0];
                this.arg1 = this.arguments[1];
            }
        }

        protected Object invokeJoinpoint(PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object) throws Throwable {
            return null;
        }

        public JoinPoint_attach3085019539260813833() {
        }

        public JoinPoint_attach3085019539260813833(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_attach3085019539260813833(JoinPoint_attach3085019539260813833 joinPoint_attach3085019539260813833, PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object) {
            this(joinPoint_attach3085019539260813833.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
            this.arg0 = fqn;
            this.arg1 = object;
        }

        protected JoinPoint_attach3085019539260813833(JoinPoint_attach3085019539260813833 joinPoint_attach3085019539260813833, PojoCacheImpl pojoCacheImpl) {
            this(joinPoint_attach3085019539260813833.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$cache$pojo$impl$PojoCacheImpl$attach$aop(this.arg0, this.arg1);
        }

        protected Object dispatch(PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object) throws PojoCacheException {
            return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$attach$aop(fqn, object);
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }

    public static class JoinPoint_attach_N_6020276434135444173
    extends MethodInvocation
    implements Untransformable {
        boolean inconsistentArgs = false;
        public Fqn arg0;
        public Object arg1;
        public String arg2;
        protected transient PojoCacheImpl typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            this.inconsistentArgs = true;
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            return this.arguments;
        }

        public void setArguments(Object[] objectArray) {
            this.inconsistentArgs = true;
            this.arguments = objectArray;
        }

        final void enforceArgsConsistency() {
            if (this.inconsistentArgs) {
                this.arg0 = (Fqn)this.arguments[0];
                this.arg1 = this.arguments[1];
                this.arg2 = (String)this.arguments[2];
            }
        }

        protected Object invokeJoinpoint(PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object, String string) throws Throwable {
            return null;
        }

        public JoinPoint_attach_N_6020276434135444173() {
        }

        public JoinPoint_attach_N_6020276434135444173(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_attach_N_6020276434135444173(JoinPoint_attach_N_6020276434135444173 joinPoint_attach_N_6020276434135444173, PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object, String string) {
            this(joinPoint_attach_N_6020276434135444173.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
            this.arg0 = fqn;
            this.arg1 = object;
            this.arg2 = string;
        }

        protected JoinPoint_attach_N_6020276434135444173(JoinPoint_attach_N_6020276434135444173 joinPoint_attach_N_6020276434135444173, PojoCacheImpl pojoCacheImpl) {
            this(joinPoint_attach_N_6020276434135444173.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$cache$pojo$impl$PojoCacheImpl$attach$aop(this.arg0, this.arg1, this.arg2);
        }

        protected Object dispatch(PojoCacheImpl pojoCacheImpl, Fqn fqn, Object object, String string) throws PojoCacheException {
            return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$attach$aop(fqn, object, string);
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }

    public static class JoinPoint_detach_N_6302035201148273652
    extends MethodInvocation
    implements Untransformable {
        boolean inconsistentArgs = false;
        public Fqn arg0;
        public String arg1;
        protected transient PojoCacheImpl typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            this.inconsistentArgs = true;
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public void setArguments(Object[] objectArray) {
            this.inconsistentArgs = true;
            this.arguments = objectArray;
        }

        final void enforceArgsConsistency() {
            if (this.inconsistentArgs) {
                this.arg0 = (Fqn)this.arguments[0];
                this.arg1 = (String)this.arguments[1];
            }
        }

        protected Object invokeJoinpoint(PojoCacheImpl pojoCacheImpl, Fqn fqn, String string) throws Throwable {
            return null;
        }

        public JoinPoint_detach_N_6302035201148273652() {
        }

        public JoinPoint_detach_N_6302035201148273652(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_detach_N_6302035201148273652(JoinPoint_detach_N_6302035201148273652 joinPoint_detach_N_6302035201148273652, PojoCacheImpl pojoCacheImpl, Fqn fqn, String string) {
            this(joinPoint_detach_N_6302035201148273652.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
            this.arg0 = fqn;
            this.arg1 = string;
        }

        protected JoinPoint_detach_N_6302035201148273652(JoinPoint_detach_N_6302035201148273652 joinPoint_detach_N_6302035201148273652, PojoCacheImpl pojoCacheImpl) {
            this(joinPoint_detach_N_6302035201148273652.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$cache$pojo$impl$PojoCacheImpl$detach$aop(this.arg0, this.arg1);
        }

        protected Object dispatch(PojoCacheImpl pojoCacheImpl, Fqn fqn, String string) throws PojoCacheException {
            return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$detach$aop(fqn, string);
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }

    public static class JoinPoint_find_N_7063709169143275953
    extends MethodInvocation
    implements Untransformable {
        boolean inconsistentArgs = false;
        public Fqn arg0;
        protected transient PojoCacheImpl typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            this.inconsistentArgs = true;
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public void setArguments(Object[] objectArray) {
            this.inconsistentArgs = true;
            this.arguments = objectArray;
        }

        final void enforceArgsConsistency() {
            if (this.inconsistentArgs) {
                this.arg0 = (Fqn)this.arguments[0];
            }
        }

        protected Object invokeJoinpoint(PojoCacheImpl pojoCacheImpl, Fqn fqn) throws Throwable {
            return null;
        }

        public JoinPoint_find_N_7063709169143275953() {
        }

        public JoinPoint_find_N_7063709169143275953(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_find_N_7063709169143275953(JoinPoint_find_N_7063709169143275953 joinPoint_find_N_7063709169143275953, PojoCacheImpl pojoCacheImpl, Fqn fqn) {
            this(joinPoint_find_N_7063709169143275953.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
            this.arg0 = fqn;
        }

        protected JoinPoint_find_N_7063709169143275953(JoinPoint_find_N_7063709169143275953 joinPoint_find_N_7063709169143275953, PojoCacheImpl pojoCacheImpl) {
            this(joinPoint_find_N_7063709169143275953.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$cache$pojo$impl$PojoCacheImpl$find$aop(this.arg0);
        }

        protected Object dispatch(PojoCacheImpl pojoCacheImpl, Fqn fqn) throws PojoCacheException {
            return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$find$aop(fqn);
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }

    public static class JoinPoint_findAll8569763146126551603
    extends MethodInvocation
    implements Untransformable {
        boolean inconsistentArgs = false;
        public Fqn arg0;
        protected transient PojoCacheImpl typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            this.inconsistentArgs = true;
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public void setArguments(Object[] objectArray) {
            this.inconsistentArgs = true;
            this.arguments = objectArray;
        }

        final void enforceArgsConsistency() {
            if (this.inconsistentArgs) {
                this.arg0 = (Fqn)this.arguments[0];
            }
        }

        protected Map invokeJoinpoint(PojoCacheImpl pojoCacheImpl, Fqn fqn) throws Throwable {
            return null;
        }

        public JoinPoint_findAll8569763146126551603() {
        }

        public JoinPoint_findAll8569763146126551603(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_findAll8569763146126551603(JoinPoint_findAll8569763146126551603 joinPoint_findAll8569763146126551603, PojoCacheImpl pojoCacheImpl, Fqn fqn) {
            this(joinPoint_findAll8569763146126551603.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
            this.arg0 = fqn;
        }

        protected JoinPoint_findAll8569763146126551603(JoinPoint_findAll8569763146126551603 joinPoint_findAll8569763146126551603, PojoCacheImpl pojoCacheImpl) {
            this(joinPoint_findAll8569763146126551603.info);
            this.typedTargetObject = pojoCacheImpl;
            super.setTargetObject((Object)pojoCacheImpl);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$cache$pojo$impl$PojoCacheImpl$findAll$aop(this.arg0);
        }

        protected Map dispatch(PojoCacheImpl pojoCacheImpl, Fqn fqn) throws PojoCacheException {
            return pojoCacheImpl.org$jboss$cache$pojo$impl$PojoCacheImpl$findAll$aop(fqn);
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }
}

