/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors.dynamic;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.collection.CachedSetImpl;
import org.jboss.cache.pojo.collection.CollectionInterceptorUtil;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;

public class CachedSetInterceptor
extends AbstractCollectionInterceptor {
    private Map methodMap_;
    private static final Map managedMethods_ = CollectionInterceptorUtil.getManagedMethods(Set.class);
    private Set cacheImpl_;
    private Set current_;
    private Set inMemImpl_;

    public CachedSetInterceptor(PojoCacheImpl cache, Fqn fqn, Class clazz, Set obj) {
        super(cache, fqn);
        this.methodMap_ = CollectionInterceptorUtil.getMethodMap(clazz);
        this.cacheImpl_ = new CachedSetImpl(cache, this);
        this.inMemImpl_ = obj;
        this.current_ = this.cacheImpl_;
    }

    private CachedSetInterceptor(PojoCacheImpl cache, Fqn fqn) {
        super(cache, fqn);
    }

    public Object clone() {
        CachedSetInterceptor interceptor = new CachedSetInterceptor(this.cache, this.fqn);
        interceptor.setFqn(this.getFqn());
        interceptor.setAopInstance(this.getAopInstance());
        interceptor.setCurrentCopy(this.getCurrentCopy());
        interceptor.setInMemoryCopy(this.getInMemoryCopy());
        interceptor.setCacheCopy(this.getCacheCopy());
        return interceptor;
    }

    public void setInterceptor(Interceptor intcptr) {
        CachedSetInterceptor interceptor = (CachedSetInterceptor)intcptr;
        this.setFqn(interceptor.getFqn());
        this.setAopInstance(interceptor.getAopInstance());
        this.setCurrentCopy(interceptor.getCurrentCopy());
        this.setInMemoryCopy(interceptor.getInMemoryCopy());
        this.setCacheCopy(interceptor.getCacheCopy());
    }

    public Object getCurrentCopy() {
        return this.current_;
    }

    void setInMemoryCopy(Object obj) {
        this.inMemImpl_ = (Set)obj;
    }

    Object getInMemoryCopy() {
        return this.inMemImpl_;
    }

    void setCacheCopy(Object obj) {
        this.cacheImpl_ = (Set)obj;
    }

    Object getCacheCopy() {
        return this.cacheImpl_;
    }

    void setCurrentCopy(Object obj) {
        this.current_ = (Set)obj;
    }

    public void attach(Fqn fqn, boolean copyToCache) {
        super.attach(fqn, copyToCache);
        if (copyToCache) {
            this.toCache();
        }
        this.current_ = this.cacheImpl_;
    }

    private void toCache() {
        if (this.inMemImpl_ == null) {
            throw new IllegalStateException("CachedSetInterceptor.toCache(). inMemImpl is null.");
        }
        Iterator it = this.inMemImpl_.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            it.remove();
            this.cacheImpl_.add(obj);
        }
        this.inMemImpl_ = null;
    }

    public void detach(boolean removeFromCache) {
        super.detach(removeFromCache);
        this.toMemory(removeFromCache);
        this.current_ = this.inMemImpl_;
    }

    private void toMemory(boolean removeFromCache) {
        if (this.inMemImpl_ == null) {
            this.inMemImpl_ = new HashSet();
        }
        this.inMemImpl_.clear();
        Iterator it = this.cacheImpl_.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (removeFromCache) {
                it.remove();
            }
            this.inMemImpl_.add(obj);
        }
    }

    public String getName() {
        return "CachedSetInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.current_ == null) {
            throw new IllegalStateException("CachedSetInterceptor.invoke(). current_ is null.");
        }
        return CollectionInterceptorUtil.invoke(invocation, this, this.current_, this.methodMap_, managedMethods_);
    }
}

