/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.GeneratedAdvisorDomain;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.GeneratedInstanceAdvisorMixin;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.cache.pojo.annotation.Reentrant;

@Reentrant
abstract class CachedListAbstract
implements List,
Advised {
    private static transient Advisor aop$classAdvisor$aop = new CachedListAbstractAdvisor();
    protected volatile transient Advisor currentAdvisor$aop = this._getAdvisor();
    protected transient InstanceAdvisor instanceAdvisor$aop;

    CachedListAbstract() {
    }

    public void clear() {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            objs[i] = this.get(i);
        }
        return objs;
    }

    public Object[] toArray(Object[] a) {
        int looper;
        int actualLength = this.size();
        if (actualLength > a.length) {
            a = new Object[actualLength];
        }
        for (looper = 0; looper < actualLength; ++looper) {
            a[looper] = this.get(looper);
        }
        while (looper < a.length) {
            a[looper] = null;
            ++looper;
        }
        return a;
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.remove(i);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        if (c.size() == 0) {
            return false;
        }
        for (Object o : c) {
            this.add(index++, o);
        }
        return true;
    }

    public boolean addAll(Collection c) {
        if (c.size() == 0) {
            return false;
        }
        for (Object o : c) {
            this.add(o);
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        for (Object aC : c) {
            if (this.contains(aC)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    public int org$jboss$cache$pojo$collection$CachedListAbstract$hashCode$aop() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            Object o = this.get(i);
            result = 31 * result + (o == null ? 0 : o.hashCode());
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object value1 = this.get(i);
            Object value2 = list.get(i);
            if ((value1 != null || value2 == null) && (value1 == null || value1.equals(value2))) continue;
            return false;
        }
        return true;
    }

    public String org$jboss$cache$pojo$collection$CachedListAbstract$toString$aop() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object key = this.get(i);
            buf.append("[").append(key).append("]");
            if (i > size) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public boolean retainAll(Collection c) {
        boolean changedAnything = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            changedAnything = true;
        }
        return changedAnything;
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public static Advisor _getClassAdvisor() {
        return aop$classAdvisor$aop;
    }

    protected Advisor getCurrentAdvisor$aop() {
        if (this.currentAdvisor$aop == null) {
            this.currentAdvisor$aop = this._getAdvisor();
        }
        return this.currentAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        if (this.instanceAdvisor$aop == null) {
            CachedListAbstract cachedListAbstract = this;
            synchronized (cachedListAbstract) {
                if (this.instanceAdvisor$aop == null) {
                    Advisor advisor;
                    this.currentAdvisor$aop = advisor = ((CachedListAbstractAdvisor)aop$classAdvisor$aop).createInstanceAdvisor(this);
                    this.instanceAdvisor$aop = (InstanceAdvisor)advisor;
                }
            }
        }
        return this.instanceAdvisor$aop;
    }

    public int hashCode() {
        return ((CachedListAbstractAdvisor)this.getCurrentAdvisor$aop()).hashCode2593808613140459179(this);
    }

    public String toString() {
        return ((CachedListAbstractAdvisor)this.getCurrentAdvisor$aop()).toString6853976482757027775(this);
    }

    public static class CachedListAbstractAdvisor
    extends GeneratedClassAdvisor
    implements Untransformable {
        protected Domain domain;
        protected MethodInfo aop$MethodInfo_hashCode2593808613140459179;
        public JoinPoint_hashCode2593808613140459179 joinpoint_hashCode2593808613140459179;
        protected MethodInfo aop$MethodInfo_toString6853976482757027775;
        public JoinPoint_toString6853976482757027775 joinpoint_toString6853976482757027775;

        public Domain getDomain() {
            return this.domain;
        }

        protected void initialiseMethods() {
            Object var2_1 = null;
            this.aop$MethodInfo_hashCode2593808613140459179 = new MethodInfo(Class.forName("org.jboss.cache.pojo.collection.CachedListAbstract"), 2593808613140459179L, 1842789431873084758L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_hashCode2593808613140459179);
            Object var4_2 = null;
            this.aop$MethodInfo_toString6853976482757027775 = new MethodInfo(Class.forName("org.jboss.cache.pojo.collection.CachedListAbstract"), 6853976482757027775L, -7225163515019037661L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_toString6853976482757027775);
        }

        protected void initialiseConstructors(Collection collection) {
        }

        protected void initialiseConstructions(Collection collection) {
        }

        protected void initialiseFieldReads(Collection collection) {
        }

        protected void initialiseFieldWrites(Collection collection) {
        }

        protected void initialiseCallers() {
        }

        protected void initialise(AspectManager aspectManager, boolean bl) {
            String string = Domain.getDomainName(((Object)((Object)this)).getClass().getDeclaringClass(), (boolean)bl);
            this.domain = new GeneratedAdvisorDomain(aspectManager, string, ((Object)((Object)this)).getClass().getDeclaringClass(), bl);
            this.domain.setInheritsBindings(true);
            super.initialise(((Object)((Object)this)).getClass().getDeclaringClass(), (AspectManager)this.domain);
        }

        public CachedListAbstractAdvisor() {
            super("org.jboss.cache.pojo.collection.CachedListAbstract");
            this.initialise(AspectManager.instance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()), false);
        }

        public CachedListAbstractAdvisor(CachedListAbstractAdvisor cachedListAbstractAdvisor) {
            super("org.jboss.cache.pojo.collection.CachedListAbstract", (GeneratedClassAdvisor)cachedListAbstractAdvisor);
            this.initialise((AspectManager)cachedListAbstractAdvisor.getDomain(), true);
        }

        protected CachedListAbstractAdvisor(String string) {
            super(string);
        }

        protected CachedListAbstractAdvisor(String string, GeneratedClassAdvisor generatedClassAdvisor) {
            super(string, generatedClassAdvisor);
        }

        public Advisor createInstanceAdvisor(Object object) {
            return new CachedListAbstractInstanceAdvisor(object, this);
        }

        protected int hashCode2593808613140459179(CachedListAbstract cachedListAbstract) {
            if (this.joinpoint_hashCode2593808613140459179 == null && this.aop$MethodInfo_hashCode2593808613140459179 != null && this.aop$MethodInfo_hashCode2593808613140459179.hasAdvices()) {
                this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_hashCode2593808613140459179 == null) {
                        if (this.aop$MethodInfo_hashCode2593808613140459179 == null) {
                        } else if (!this.aop$MethodInfo_hashCode2593808613140459179.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_hashCode2593808613140459179);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_hashCode2593808613140459179 == null) {
                return cachedListAbstract.org$jboss$cache$pojo$collection$CachedListAbstract$hashCode$aop();
            }
            return this.joinpoint_hashCode2593808613140459179.invokeJoinpoint(cachedListAbstract);
        }

        protected String toString6853976482757027775(CachedListAbstract cachedListAbstract) {
            if (this.joinpoint_toString6853976482757027775 == null && this.aop$MethodInfo_toString6853976482757027775 != null && this.aop$MethodInfo_toString6853976482757027775.hasAdvices()) {
                this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_toString6853976482757027775 == null) {
                        if (this.aop$MethodInfo_toString6853976482757027775 == null) {
                        } else if (!this.aop$MethodInfo_toString6853976482757027775.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_toString6853976482757027775);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_toString6853976482757027775 == null) {
                return cachedListAbstract.org$jboss$cache$pojo$collection$CachedListAbstract$toString$aop();
            }
            return this.joinpoint_toString6853976482757027775.invokeJoinpoint(cachedListAbstract);
        }
    }

    public static class CachedListAbstractInstanceAdvisor
    extends CachedListAbstractAdvisor
    implements Untransformable,
    InstanceAdvisor {
        GeneratedInstanceAdvisorMixin instanceAdvisorMixin;
        CachedListAbstractAdvisor parent = null;
        protected boolean aop$MethodInfo_hashCode2593808613140459179_updated;
        protected boolean aop$MethodInfo_toString6853976482757027775_updated;

        protected void advicesUpdated() {
            Object var2_1 = null;
            this.aop$MethodInfo_hashCode2593808613140459179_updated = true;
            this.aop$MethodInfo_toString6853976482757027775_updated = true;
        }

        protected void lockWriteInterceptorChains() {
            Object var2_1 = null;
            this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().lock();
            this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().lock();
        }

        protected void unlockWriteInterceptorChains() {
            Object var2_1 = null;
            this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().unlock();
            this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().unlock();
        }

        public SimpleMetaData getMetaData() {
            return this.instanceAdvisorMixin.getMetaData();
        }

        public Object getInstance() {
            return this.instanceAdvisorMixin.getInstance();
        }

        public boolean hasInterceptors() {
            return this.instanceAdvisorMixin.hasInterceptors();
        }

        public void insertInterceptor(Interceptor interceptor) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptor(interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void insertInterceptor(int n, Interceptor interceptor) throws IndexOutOfBoundsException {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptor(n, interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void insertInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptor(Interceptor interceptor) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptor(interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptor(int n, Interceptor interceptor) throws IndexOutOfBoundsException {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptor(n, interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void removeInterceptor(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.removeInterceptor(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void removeInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.removeInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public Interceptor[] getInterceptors() {
            return this.instanceAdvisorMixin.getInterceptors();
        }

        public Interceptor[] getInterceptors(Interceptor[] interceptorArray) {
            return this.instanceAdvisorMixin.getInterceptors(interceptorArray);
        }

        public Object getPerInstanceAspect(String string) {
            return this.instanceAdvisorMixin.getPerInstanceAspect(string);
        }

        public Object getPerInstanceAspect(AspectDefinition aspectDefinition) {
            return this.instanceAdvisorMixin.getPerInstanceAspect(aspectDefinition);
        }

        public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition aspectDefinition) {
            return this.instanceAdvisorMixin.getPerInstanceJoinpointAspect(joinpoint, aspectDefinition);
        }

        protected void doRebuildForInstance() {
            this.lockWriteInterceptorChains();
            try {
                this.internalRebuildInterceptors();
                if (this.instanceAdvisorMixin.hasInterceptors()) {
                    this.advicesUpdated();
                }
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public CachedListAbstractInstanceAdvisor(Object object, CachedListAbstractAdvisor cachedListAbstractAdvisor) {
            super(cachedListAbstractAdvisor);
            this.instanceAdvisorMixin = new GeneratedInstanceAdvisorMixin(object, (GeneratedClassAdvisor)cachedListAbstractAdvisor);
            this.parent = cachedListAbstractAdvisor;
        }

        protected void initialiseInfosForInstance() {
            Object var2_1 = null;
            CachedListAbstractAdvisor cachedListAbstractAdvisor = (CachedListAbstractAdvisor)CachedListAbstract._getClassAdvisor();
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.aop$MethodInfo_hashCode2593808613140459179 = super.copyInfoFromClassAdvisor(((CachedListAbstractAdvisor)CachedListAbstract._getClassAdvisor()).aop$MethodInfo_hashCode2593808613140459179);
            this.aop$MethodInfo_toString6853976482757027775 = super.copyInfoFromClassAdvisor(((CachedListAbstractAdvisor)CachedListAbstract._getClassAdvisor()).aop$MethodInfo_toString6853976482757027775);
            ((ClassAdvisor)this).fieldReadInfos = arrayList.toArray(new FieldInfo[arrayList.size()]);
            ((ClassAdvisor)this).fieldWriteInfos = arrayList2.toArray(new FieldInfo[arrayList2.size()]);
        }

        protected int hashCode2593808613140459179(CachedListAbstract cachedListAbstract) {
            this.checkVersion();
            if (this.aop$MethodInfo_hashCode2593808613140459179_updated) {
                this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_hashCode2593808613140459179.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_hashCode2593808613140459179.getInterceptors()));
                    this.joinpoint_hashCode2593808613140459179 = null;
                    this.aop$MethodInfo_hashCode2593808613140459179_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_hashCode2593808613140459179);
                }
                finally {
                    this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.hashCode2593808613140459179(cachedListAbstract);
        }

        protected String toString6853976482757027775(CachedListAbstract cachedListAbstract) {
            this.checkVersion();
            if (this.aop$MethodInfo_toString6853976482757027775_updated) {
                this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_toString6853976482757027775.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_toString6853976482757027775.getInterceptors()));
                    this.joinpoint_toString6853976482757027775 = null;
                    this.aop$MethodInfo_toString6853976482757027775_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_toString6853976482757027775);
                }
                finally {
                    this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.toString6853976482757027775(cachedListAbstract);
        }
    }

    public static class JoinPoint_hashCode2593808613140459179
    extends MethodInvocation
    implements Untransformable {
        protected transient CachedListAbstract typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        protected int invokeJoinpoint(CachedListAbstract cachedListAbstract) throws Throwable {
            return 0;
        }

        public JoinPoint_hashCode2593808613140459179() {
        }

        public JoinPoint_hashCode2593808613140459179(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_hashCode2593808613140459179(JoinPoint_hashCode2593808613140459179 joinPoint_hashCode2593808613140459179, CachedListAbstract cachedListAbstract) {
            this(joinPoint_hashCode2593808613140459179.info);
            this.typedTargetObject = cachedListAbstract;
            super.setTargetObject((Object)cachedListAbstract);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return new Integer(this.typedTargetObject.org$jboss$cache$pojo$collection$CachedListAbstract$hashCode$aop());
        }

        protected int dispatch(CachedListAbstract cachedListAbstract) {
            return cachedListAbstract.org$jboss$cache$pojo$collection$CachedListAbstract$hashCode$aop();
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }

    public static class JoinPoint_toString6853976482757027775
    extends MethodInvocation
    implements Untransformable {
        protected transient CachedListAbstract typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        protected String invokeJoinpoint(CachedListAbstract cachedListAbstract) throws Throwable {
            return null;
        }

        public JoinPoint_toString6853976482757027775() {
        }

        public JoinPoint_toString6853976482757027775(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_toString6853976482757027775(JoinPoint_toString6853976482757027775 joinPoint_toString6853976482757027775, CachedListAbstract cachedListAbstract) {
            this(joinPoint_toString6853976482757027775.info);
            this.typedTargetObject = cachedListAbstract;
            super.setTargetObject((Object)cachedListAbstract);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$cache$pojo$collection$CachedListAbstract$toString$aop();
        }

        protected String dispatch(CachedListAbstract cachedListAbstract) {
            return cachedListAbstract.org$jboss$cache$pojo$collection$CachedListAbstract$toString$aop();
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }
}

