/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors.dynamic;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.array.ArrayRegistry;
import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheAlreadyDetachedException;
import org.jboss.cache.pojo.collection.CachedArray;
import org.jboss.cache.pojo.collection.CachedArrayRegistry;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoUtil;
import org.jboss.cache.pojo.interceptors.dynamic.BaseInterceptor;
import org.jboss.cache.pojo.util.ObjectUtil;

public class CacheFieldInterceptor
implements BaseInterceptor {
    private final Log log_ = LogFactory.getLog(CacheFieldInterceptor.class);
    Cache<Object, Object> cache_;
    private PojoCacheImpl pCache_;
    Fqn fqn_;
    private String name_;
    private PojoInstance pojoInstance_;
    private PojoUtil util_;

    public CacheFieldInterceptor(PojoCacheImpl pCache, Fqn fqn, CachedType type) {
        this.pCache_ = pCache;
        this.cache_ = this.pCache_.getCache();
        this.fqn_ = fqn;
        this.util_ = new PojoUtil();
    }

    private CacheFieldInterceptor() {
    }

    public PojoInstance getAopInstance() {
        return this.pojoInstance_;
    }

    public Object clone() {
        CacheFieldInterceptor interceptor = new CacheFieldInterceptor();
        interceptor.setFqn(this.getFqn());
        interceptor.setAopInstance(this.getAopInstance());
        return interceptor;
    }

    public void setInterceptor(Interceptor intcptr) {
        BaseInterceptor interceptor = (BaseInterceptor)intcptr;
        this.setFqn(interceptor.getFqn());
        this.setAopInstance(interceptor.getAopInstance());
    }

    public void setAopInstance(PojoInstance pojoInstance) {
        this.pojoInstance_ = pojoInstance;
    }

    public String getName() {
        if (this.name_ == null) {
            this.name_ = "CacheFieldInterceptor on [" + this.fqn_ + "]";
        }
        return this.name_;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof MethodInvocation) {
            return invocation.invokeNext();
        }
        if (invocation instanceof FieldWriteInvocation) {
            Object target = invocation.getTargetObject();
            FieldInvocation fieldInvocation = (FieldInvocation)invocation;
            Advisor advisor = fieldInvocation.getAdvisor();
            Field field = fieldInvocation.getField();
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("invoke(): field write interception for fqn: " + this.fqn_ + " and field: " + field));
            }
            this.verifyAttached(target);
            CachedType fieldType = this.pCache_.getCachedType(field.getType());
            Object value = ((FieldWriteInvocation)fieldInvocation).getValue();
            if (!CachedType.isNonReplicable(field)) {
                if (CachedType.isSimpleAttribute(field)) {
                    this.cache_.put(this.fqn_, (Object)field.getName(), value);
                } else {
                    this.pCache_.attach(this.fqn_, value, field.getName(), target);
                }
            }
            this.util_.inMemorySubstitution(target, field, value);
        } else if (invocation instanceof FieldReadInvocation) {
            Object target = invocation.getTargetObject();
            FieldInvocation fieldInvocation = (FieldInvocation)invocation;
            Field field = fieldInvocation.getField();
            Advisor advisor = fieldInvocation.getAdvisor();
            CachedType fieldType = this.pCache_.getCachedType(field.getType());
            if (!CachedType.isNonReplicable(field)) {
                Object result;
                if (CachedType.isSimpleAttribute(field)) {
                    result = this.cache_.get(this.fqn_, (Object)field.getName());
                } else {
                    result = this.pCache_.find(this.fqn_, field.getName(), target);
                    if (result != null && result.getClass().isArray()) {
                        this.registerArrayWithAOP(target, field.getName(), result);
                    }
                }
                if (result == null) {
                    this.verifyAttached(target);
                }
                this.util_.inMemorySubstitution(target, field, result);
                invocation.invokeNext();
                return result;
            }
        }
        return invocation.invokeNext();
    }

    private void registerArrayWithAOP(Object owner, String fieldName, Object array) {
        CachedArray cached = CachedArrayRegistry.lookup(array);
        if (cached != null) {
            ArrayRegistry.getInstance().addFieldReference(owner, fieldName, array);
        }
    }

    private void verifyAttached(Object target) {
        if (this.cache_.get(this.fqn_, (Object)"POJOCache.PojoInstance") != null) {
            return;
        }
        String identity = ObjectUtil.identityString(target);
        throw new PojoCacheAlreadyDetachedException(identity + " has possibly been detached remotely. Internal id: " + this.fqn_);
    }

    public Fqn getFqn() {
        return this.fqn_;
    }

    public void setFqn(Fqn fqn) {
        this.fqn_ = fqn;
    }
}

