/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.Reference;
import org.jboss.cache.pojo.impl.AbstractHandler;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectGraphHandler
extends AbstractHandler {
    private PojoCacheImpl cache;
    private InternalHelper internal_;
    private static final Log log = LogFactory.getLog(ObjectGraphHandler.class);

    public ObjectGraphHandler(PojoCacheImpl cache, InternalHelper internal) {
        this.cache = cache;
        this.internal_ = internal;
    }

    @Override
    protected Fqn<?> getFqn(Object obj) {
        return null;
    }

    @Override
    protected boolean handles(Class<?> clazz) {
        return false;
    }

    @Override
    protected Object get(Fqn<?> fqn, Class<?> clazz, PojoInstance pojoInstance) throws CacheException {
        Object obj = this.cache.find(fqn);
        if (obj == null) {
            throw new PojoCacheException("ObjectGraphHandler.get(): null object from internal ref node. Internal ref node: " + fqn);
        }
        return obj;
    }

    @Override
    protected void put(Fqn<?> fqn, Reference reference, Object obj) throws CacheException {
        this.setupRefCounting(fqn, reference);
    }

    boolean isMultipleReferenced(Fqn<?> internalFqn) {
        PojoInstance pojoInstance = null;
        try {
            pojoInstance = this.internal_.getPojoInstance(internalFqn);
        }
        catch (CacheException e) {
            throw new PojoCacheException("Exception in isMultipleReferenced", e);
        }
        return InternalHelper.isMultipleReferenced(pojoInstance);
    }

    @Override
    protected Object remove(Fqn<?> fqn, Reference reference, Object pojo) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("remove(): removing object fqn: " + reference + " Will just de-reference it."));
        }
        this.removeFromReference(fqn, reference);
        return null;
    }

    private void removeFromReference(Fqn<?> originalFqn, Reference reference) throws CacheException {
        if (this.decrementRefCount(originalFqn, reference) == -1) {
            this.cache.detach(originalFqn);
        }
    }

    private void setupRefCounting(Fqn<?> fqn, Reference reference) throws CacheException {
        this.incrementRefCount(fqn, reference);
    }

    private int incrementRefCount(Fqn<?> originalFqn, Reference reference) throws CacheException {
        return this.internal_.incrementRefCount(originalFqn, reference);
    }

    private int decrementRefCount(Fqn<?> originalFqn, Reference reference) throws CacheException {
        return this.internal_.decrementRefCount(originalFqn, reference);
    }
}

