/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.connect.config;

import java.util.Formatter;
import org.jboss.capedwarf.common.env.Environment;
import org.jboss.capedwarf.common.env.EnvironmentFactory;
import org.jboss.capedwarf.common.env.EnvironmentType;
import org.jboss.capedwarf.connect.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration<T>
extends Configuration<T> {
    public DefaultConfiguration() {
        this(null);
    }

    public DefaultConfiguration(String appspotName) {
        Environment env;
        boolean debug = appspotName == null || appspotName.length() == 0;
        this.setDebugMode(debug);
        this.setDebugLogging(debug);
        this.setSslPort(443);
        this.setPort(this.isDebugMode() ? 8080 : 80);
        String localhost = "localhost";
        int port = this.getPort();
        if (port != 80) {
            localhost = localhost + ":" + port;
        }
        if ((env = EnvironmentFactory.getEnvironment()).envType() == EnvironmentType.ANDROID) {
            localhost = "://10.0.2.2:8080";
        }
        this.setHostName(this.isDebugMode() ? localhost : new Formatter().format("://%1s.appspot.com", appspotName).toString());
    }
}

