/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.gae.cache;

import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import org.jboss.capedwarf.server.gae.cache.DNCacheEntryLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIDCacheEntryLookup
extends DNCacheEntryLookup {
    private static final Logger log = Logger.getLogger(OIDCacheEntryLookup.class.getName());
    private String oidClassName = "org.datanucleus.identity.OIDImpl";
    private volatile Class<?> oidClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object toImplementationId(Class<?> entryType, Object id) {
        if (this.oidClass == null) {
            OIDCacheEntryLookup oIDCacheEntryLookup = this;
            synchronized (oIDCacheEntryLookup) {
                if (this.oidClass == null) {
                    if (this.cache == null) {
                        this.oidClass = Void.class;
                        log.warning("Cache is null, forgot to set it?");
                        return null;
                    }
                    try {
                        this.oidClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.oidClassName);
                    }
                    catch (ClassNotFoundException e) {
                        log.warning("Cannot create OID: " + e);
                        this.oidClass = Void.class;
                    }
                }
            }
        }
        if (this.oidClass == Void.class) {
            return null;
        }
        try {
            Constructor<?> ctor = this.oidClass.getConstructor(String.class, Object.class);
            return ctor.newInstance(entryType.getName(), id);
        }
        catch (Exception e) {
            log.fine("Cannot create OID: " + e);
            return null;
        }
    }

    public void setOidClassName(String oidClassName) {
        this.oidClassName = oidClassName;
    }
}

