/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.gae.persistence;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import org.jboss.capedwarf.jpa.Entity;
import org.jboss.capedwarf.server.api.persistence.AbstractStatelessAdapterFactory;
import org.jboss.capedwarf.server.api.persistence.StatelessAdapter;

@ApplicationScoped
public class StatefulStatelessAdapterFactory
extends AbstractStatelessAdapterFactory {
    protected StatelessAdapter doCreateStatelessAdapter(EntityManager em) {
        return new EMStatelessAdapter(em);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EMStatelessAdapter
    implements StatelessAdapter {
        private final EntityManager em;

        private EMStatelessAdapter(EntityManager em) {
            this.em = em;
        }

        public Long insert(Object entity) {
            if (!(entity instanceof Entity)) {
                throw new IllegalArgumentException("Not Entity: " + entity);
            }
            this.em.persist(entity);
            this.em.flush();
            return ((Entity)entity).getId();
        }

        public void update(Object entity) {
            this.em.merge(entity);
            this.em.flush();
        }

        public void delete(Object entity) {
            this.em.remove(entity);
        }

        public <T> T get(Class<T> entityClass, Serializable id) {
            return (T)this.em.find(entityClass, (Object)id);
        }

        public void refresh(Object entity) {
            this.em.refresh(entity);
        }

        public void close() {
        }
    }
}

