/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.gae.tx;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Transaction;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

@RequestScoped
@Alternative
public class GAEUserTransaction
implements UserTransaction {
    protected Logger log = Logger.getLogger(GAEUserTransaction.class.getName());

    public void begin() throws NotSupportedException, SystemException {
        DatastoreService service = DatastoreServiceFactory.getDatastoreService();
        service.beginTransaction();
    }

    protected Transaction getCurrentTransaction(boolean allowNoCurrentTx) {
        DatastoreService service = DatastoreServiceFactory.getDatastoreService();
        Transaction tx = service.getCurrentTransaction();
        if (tx == null && !allowNoCurrentTx) {
            throw new IllegalStateException("No current transaction!");
        }
        return tx;
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.getCurrentTransaction(false).commit();
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getCurrentTransaction(true);
        if (tx == null) {
            return 6;
        }
        if (tx.isActive()) {
            return 0;
        }
        return 5;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getCurrentTransaction(false).rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.log.warning("setRollbackOnly is not supported");
    }

    public void setTransactionTimeout(int i) throws SystemException {
        this.log.warning("setTransactionTimeout is not supported");
    }
}

