/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.gae.io;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.appengine.api.blobstore.ByteRange;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileServiceFactory;
import com.google.appengine.api.files.FileWriteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.server.api.io.AbstractBlobService;
import org.jboss.capedwarf.server.api.io.Blob;
import org.jboss.capedwarf.server.gae.io.BlobImpl;

@ApplicationScoped
public class BlobServiceImpl
extends AbstractBlobService {
    private BlobstoreService blobstoreService = BlobstoreServiceFactory.getBlobstoreService();
    private FileService fileService = FileServiceFactory.getFileService();

    protected Blob toBlobInternal(byte[] bytes) {
        return new BlobImpl(new com.google.appengine.api.datastore.Blob(bytes));
    }

    protected byte[] loadBytesInternal(String key, long startIndex, long endIndex) {
        BlobKey blobKey = new BlobKey(key);
        return this.blobstoreService.fetchData(blobKey, startIndex, endIndex);
    }

    public void serveBytes(String key, long start, long end, HttpServletResponse respose) throws IOException {
        BlobKey blobKey = new BlobKey(key);
        ByteRange range = end == Long.MAX_VALUE ? new ByteRange(start) : new ByteRange(start, end);
        this.blobstoreService.serve(blobKey, range, respose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String storeBytesInternal(String mimeType, ByteBuffer buffer) throws IOException {
        AppEngineFile file = this.fileService.createNewBlobFile(mimeType);
        FileWriteChannel writeChannel = this.fileService.openWriteChannel(file, true);
        try {
            writeChannel.write(buffer);
        }
        finally {
            writeChannel.closeFinally();
        }
        BlobKey blobKey = this.fileService.getBlobKey(file);
        return blobKey.getKeyString();
    }
}

