/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.gae.mail;

import com.google.appengine.api.mail.MailService;
import com.google.appengine.api.mail.MailServiceFactory;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.capedwarf.server.api.mail.impl.AbstractMailManager;

@ApplicationScoped
public class BasicMailManager
extends AbstractMailManager {
    private Logger log = Logger.getLogger(BasicMailManager.class.getName());
    private MailService mailService = MailServiceFactory.getMailService();

    public void sendEmail(String sender, String subject, String textBody, String ... tos) {
        for (String to : tos) {
            try {
                MailService.Message msg = new MailService.Message(sender, to, subject, textBody);
                this.mailService.send(msg);
            }
            catch (Throwable t) {
                this.log.warning("Failed to send email: " + t);
            }
        }
    }

    public void sendEmailToAdmins(String sender, String subject, String textBody) {
        try {
            MailService.Message msg = new MailService.Message();
            msg.setSender(sender);
            msg.setSubject(subject);
            msg.setTextBody(textBody);
            this.mailService.sendToAdmins(msg);
        }
        catch (Throwable t) {
            String info = Arrays.asList(sender, subject, textBody).toString();
            this.log.log(Level.WARNING, "Failed to send email: " + info, t);
        }
    }
}

