/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.gae.tx;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.OptimisticLockException;
import org.jboss.capedwarf.server.api.tx.TransactionPropagationType;
import org.jboss.capedwarf.server.api.tx.Transactional;
import org.jboss.capedwarf.server.api.tx.TxInterceptorDelegate;
import org.jboss.capedwarf.server.api.tx.Work;
import org.jboss.capedwarf.server.gae.tx.OptimisticLockExceptionHandler;

public class TransactionInterceptor
implements TxInterceptorDelegate,
Serializable {
    private static final long serialVersionUID = 1L;
    private static transient ThreadLocal<Tuple> emTL = new ThreadLocal();
    private transient Map<AnnotatedElement, TransactionMetadata> transactionMetadata = new HashMap<AnnotatedElement, TransactionMetadata>();
    private EntityManagerFactory factory;

    public static EntityManager getEntityManager() {
        Tuple tuple = emTL.get();
        return tuple != null ? tuple.em : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(final InvocationContext invocation) throws Exception {
        Tuple tuple = emTL.get();
        if (tuple == null) {
            tuple = new Tuple(this.factory.createEntityManager());
            emTL.set(tuple);
        }
        tuple.count++;
        try {
            Object object = new Work(){

                protected Object work() throws Exception {
                    return invocation.proceed();
                }

                protected boolean isNewTransactionRequired(boolean transactionActive) {
                    return this.isNewTransactionRequired(invocation.getMethod(), invocation.getTarget().getClass(), transactionActive);
                }

                private boolean isNewTransactionRequired(Method method, Class beanClass, boolean transactionActive) {
                    TransactionMetadata metadata = TransactionInterceptor.this.lookupTransactionMetadata(method);
                    if (metadata.isNewTransactionRequired(transactionActive)) {
                        return true;
                    }
                    return TransactionInterceptor.this.lookupTransactionMetadata(beanClass).isNewTransactionRequired(transactionActive);
                }

                protected Object handleException(Exception e) {
                    Object target;
                    if (e.getCause() instanceof OptimisticLockException && (target = invocation.getTarget()) instanceof OptimisticLockExceptionHandler) {
                        OptimisticLockExceptionHandler oleh = (OptimisticLockExceptionHandler)target;
                        return oleh.handleVersionConflict(invocation.getParameters());
                    }
                    return null;
                }
            }.workInTransaction(tuple.em.getTransaction());
            return object;
        }
        finally {
            tuple.count--;
            if (tuple.count == 0) {
                emTL.remove();
                tuple.em.close();
            }
        }
    }

    private TransactionMetadata lookupTransactionMetadata(AnnotatedElement element) {
        TransactionMetadata metadata = this.transactionMetadata.get(element);
        if (metadata == null) {
            metadata = this.loadMetadata(element);
        }
        return metadata;
    }

    private synchronized TransactionMetadata loadMetadata(AnnotatedElement element) {
        if (!this.transactionMetadata.containsKey(element)) {
            TransactionMetadata metadata = new TransactionMetadata(element);
            this.transactionMetadata.put(element, metadata);
            return metadata;
        }
        return this.transactionMetadata.get(element);
    }

    @Inject
    public void setFactory(EntityManagerFactory factory) {
        this.factory = factory;
    }

    private static class Tuple {
        private EntityManager em;
        private int count;

        private Tuple(EntityManager em) {
            this.em = em;
        }
    }

    private class TransactionMetadata {
        private boolean annotationPresent;
        private TransactionPropagationType propType;

        public TransactionMetadata(AnnotatedElement element) {
            this.annotationPresent = element.isAnnotationPresent(Transactional.class);
            if (this.annotationPresent) {
                this.propType = element.getAnnotation(Transactional.class).value();
            }
        }

        public boolean isAnnotationPresent() {
            return this.annotationPresent;
        }

        public boolean isNewTransactionRequired(boolean transactionActive) {
            return this.propType != null && this.propType.isNewTransactionRequired(transactionActive);
        }
    }
}

