/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.gae.cache;

import com.google.appengine.api.memcache.MemcacheService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.capedwarf.server.api.cache.impl.AbstractCacheConfig;
import org.jboss.capedwarf.server.api.cache.impl.AbstractCacheEntryLookup;
import org.jboss.capedwarf.server.gae.cache.LongIDCacheEntryLookup;

@ApplicationScoped
public class CacheConfigImpl
extends AbstractCacheConfig {
    private static final Map<String, Object> CONSTS = new HashMap<String, Object>();

    protected Map createConfig(String name) {
        HashMap<Object, Object> config = new HashMap<Object, Object>();
        String prefix = name + ".";
        for (String key : this.getProps().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String subKey = key.substring(prefix.length());
            String value = this.getProps().getProperty(key);
            Object c = CONSTS.get(subKey);
            if (c != null) {
                config.put(c, Integer.parseInt(value));
                continue;
            }
            MemcacheService.SetPolicy policy = null;
            for (MemcacheService.SetPolicy p : MemcacheService.SetPolicy.values()) {
                if (!p.name().equalsIgnoreCase(subKey)) continue;
                policy = p;
                break;
            }
            if (policy != null) {
                config.put(policy, Boolean.parseBoolean(value));
                continue;
            }
            config.put(subKey, value);
        }
        return config.isEmpty() ? Collections.emptyMap() : config;
    }

    protected AbstractCacheEntryLookup createLookup() {
        String cel = this.getProps().getProperty("jpa.cache-lookup.class");
        if (cel == null || cel.length() == 0) {
            return new LongIDCacheEntryLookup();
        }
        try {
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            Class<?> clazz = cl.loadClass(cel);
            return (AbstractCacheEntryLookup)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        CONSTS.put("EXPIRATION_DELTA", 0);
        CONSTS.put("EXPIRATION_DELTA_MILLIS", 1);
        CONSTS.put("EXPIRATION", 2);
    }
}

