/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.validation;

import java.lang.reflect.Array;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Size;
import org.jboss.capedwarf.validation.ValidatorFactoryProvider;

public class ValidationHelper {
    private static ValidatorFactory factory = new ValidatorFactoryProvider().createFactory();

    public static Validator createValidator() {
        return factory.getValidator();
    }

    public static void validate(Object arg) throws Exception {
        Validator validator = ValidationHelper.createValidator();
        Set violations = validator.validate(arg, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException("Invalid arg: " + arg, violations);
        }
    }

    public static void validate(Size size, Object arg) {
        if (!ValidationHelper.doValidate(size, arg)) {
            throw new ConstraintViolationException("Illegal size : " + arg, null);
        }
    }

    public static boolean doValidate(Size size, Object arg) {
        if (arg == null) {
            return true;
        }
        if (arg instanceof Number) {
            Number number = (Number)arg;
            return ValidationHelper.validate(size, number.intValue());
        }
        if (arg instanceof String) {
            String string = (String)arg;
            return ValidationHelper.validate(size, string.length());
        }
        if (arg.getClass().isArray()) {
            return ValidationHelper.validate(size, Array.getLength(arg));
        }
        return true;
    }

    private static boolean validate(Size size, int x) {
        int min = size.min();
        int max = size.max();
        return x >= min && x <= max;
    }
}

