/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.classloader.jbcl114;

import java.util.concurrent.locks.ReentrantLock;

import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.base.BaseClassLoader;

/**
 * Don't panic!  This scary, bizarre code is ONLY FOR TESTING!
 *
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class BlockingClassLoaderDomain extends ClassLoaderDomain
{
   private boolean block = true;
   private ReentrantLock lock = new ReentrantLock();
   
   protected BlockingClassLoaderDomain(String name)
   {
      super(name);
   }
   
   @Override
   protected Class<?> loadClass(BaseClassLoader classLoader, String name, boolean allExports) throws ClassNotFoundException
   {
      try
      {
         waitForIt();
      }
      catch(InterruptedException e)
      {
         throw new ClassNotFoundException("interrupted", e);
      }
      // there can be only 1
      boolean locked = lock.tryLock();
      if(!locked)
         throw new IllegalStateException("only one thread is allowed to use this class loader domain");
      return super.loadClass(classLoader, name, allExports);
   }
   
   public void unblock()
   {
      synchronized (this)
      {
         block = false;
         notifyAll();
      }
   }
   
   private void waitForIt() throws InterruptedException
   {
      if(!block) return;
      synchronized (this)
      {
         while(block)
            wait();
      }
   }
}
