/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.registry;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.TempInfo;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VFSContextConstraints;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.jboss.virtual.spi.cache.VFSCache;
import org.jboss.virtual.spi.cache.VFSCacheFactory;
import org.jboss.virtual.spi.registry.VFSRegistry;

public class DefaultVFSRegistry
extends VFSRegistry {
    protected VFSCache getCache() {
        return VFSCacheFactory.getInstance();
    }

    protected boolean isCacheable(VFSContext context) {
        Set<VFSContextConstraints> constraints = context.getConstraints();
        return constraints != null && constraints.contains((Object)VFSContextConstraints.CACHEABLE);
    }

    public void addContext(VFSContext context) {
        if (this.isCacheable(context)) {
            this.getCache().putContext(context);
        }
    }

    public void removeContext(VFSContext context) {
        if (this.isCacheable(context)) {
            this.getCache().removeContext(context);
        }
    }

    public VirtualFile getFile(URI uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        VFSContext context = this.getCache().findContext(uri);
        if (context != null) {
            String relativePath = VFSUtils.getRelativePath(context, uri);
            TempInfo ti = context.getFurthestParentTemp(relativePath);
            if (ti != null) {
                String path = ti.getPath();
                String subpath = relativePath.substring(path.length());
                VirtualFileHandler child = this.findHandler(ti.getHandler(), subpath, true);
                if (child != null) {
                    return child.getVirtualFile();
                }
            }
            VirtualFileHandler root = context.getRoot();
            VirtualFileHandler child = this.findHandler(root, relativePath, false);
            return child.getVirtualFile();
        }
        return null;
    }

    protected VirtualFileHandler findHandler(VirtualFileHandler root, String path, boolean allowNotFound) throws IOException {
        VirtualFileHandler child = root.getChild(path);
        if (child == null && !allowNotFound) {
            List<VirtualFileHandler> children = root.getChildren(true);
            throw new IOException("Child not found " + path + " for " + root + ", available children: " + children);
        }
        return child;
    }

    public VirtualFile getFile(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            return this.getFile(VFSUtils.toURI(url));
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

