/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.dependency.spi.Controller;

public class Domain {
    private String name;
    private List<Module> modules = new CopyOnWriteArrayList<Module>();
    private Map<String, Module> modulesByName = new ConcurrentHashMap<String, Module>();

    public Domain(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        Domain domain = module.getDomain();
        if (domain != null) {
            throw new IllegalArgumentException("The module is already registered with the domain " + domain.getName());
        }
        String contextName = module.getContextName();
        if (this.modulesByName.containsKey(contextName)) {
            throw new IllegalArgumentException("The context " + contextName + " is already registered in domain " + this.getName());
        }
        module.setDomain(this);
        this.modulesByName.put(contextName, module);
        this.modules.add(module);
        try {
            module.createDependencies();
        }
        catch (Throwable t) {
            this.removeModule(module);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException("Error adding module " + module, t);
        }
    }

    public Module getModule(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null module name");
        }
        return this.modulesByName.get(name);
    }

    protected Object resolve(Controller controller, Module module, Requirement requirement) {
        for (Module other : this.modules) {
            List<Capability> capabilities = other.getCapabilities();
            if (capabilities == null) continue;
            for (Capability capability : capabilities) {
                if (!capability.resolves(module, requirement)) continue;
                return other.getContextName();
            }
        }
        return null;
    }

    protected synchronized void removeModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        this.modulesByName.remove(module.getContextName());
        this.modules.remove(module);
        module.setDomain(null);
        module.removeDependencies();
    }
}

