/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.plugins.ResolvedState;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

public class RequirementDependencyItem
extends AbstractDependencyItem {
    private static final Logger log = Logger.getLogger(RequirementDependencyItem.class);
    private Module module;
    private Requirement requirement;
    private volatile Module resolvedModule;

    public RequirementDependencyItem(Module module, Requirement requirement, ControllerState state) {
        this(module, requirement, state, ControllerState.INSTALLED);
    }

    public RequirementDependencyItem(Module module, Requirement requirement, ControllerState whenRequired, ControllerState dependentState) {
        super((Object)(module != null ? module.getContextName() : null), null, whenRequired, dependentState);
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (requirement == null) {
            throw new IllegalArgumentException("Null requirement");
        }
        this.module = module;
        this.requirement = requirement;
    }

    public Module getModule() {
        return this.module;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public Module getResolvedModule() {
        return this.resolvedModule;
    }

    public boolean resolve(Controller controller) {
        Module module = this.getModule().resolveModule(this, true);
        if (module == null) {
            Requirement requirement = this.getRequirement();
            this.setResolved(requirement.isOptional() || requirement.isDynamic());
            return this.isResolved();
        }
        this.resolvedModule = module;
        if (module == this.getModule()) {
            ControllerContext context = module.getControllerContext();
            this.setIDependOn(context.getName());
            this.setResolved(true);
            return this.isResolved();
        }
        ControllerContext context = module.getControllerContext();
        if (context != null) {
            boolean resolved = this.semiResolve(context);
            if (resolved) {
                this.setIDependOn(context.getName());
                module.addDepends(this);
                if (module.getClassLoadingSpace() == null) {
                    log.warn((Object)(this.getModule() + " resolved " + this.getRequirement() + " to " + module + " which has import-all=true. Cannot check its consistency."));
                }
            }
            return this.isResolved();
        }
        this.setResolved(false);
        return this.isResolved();
    }

    protected void addDependsOnMe(Controller controller, ControllerContext context) {
        Module resolvedModule = this.getResolvedModule();
        if (resolvedModule != null && !resolvedModule.isCascadeShutdown()) {
            return;
        }
        super.addDependsOnMe(controller, context);
    }

    public boolean unresolved(Controller controller) {
        this.setIDependOn(null);
        this.setResolved(false);
        return true;
    }

    public void setResolved(ResolvedState resolved) {
        Module resolvedModule = this.getResolvedModule();
        if (resolved == ResolvedState.UNRESOLVED && resolvedModule != null) {
            resolvedModule.removeDepends(this);
            resolvedModule.removeDependsOnMe(this);
            this.resolvedModule = null;
        }
        super.setResolved(resolved);
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append(" requirement=").append((Object)this.getRequirement());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName()).append(" ").append((Object)this.getRequirement());
    }

    public String toHumanReadableString() {
        return this.getRequirement().toString();
    }
}

