/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.classfilewriter.AccessFlag;
import org.jboss.classfilewriter.ClassField;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.WritableEntry;
import org.jboss.classfilewriter.constpool.ConstPool;
import org.jboss.classfilewriter.util.DescriptorUtils;

public class ClassFile
implements WritableEntry {
    private final String name;
    private final String superclass;
    private final int accessFlags;
    private final int version;
    private final ConstPool constPool = new ConstPool();
    private final List<String> interfaces = new ArrayList<String>();
    private final Set<ClassField> fields = new HashSet<ClassField>();
    private final Set<ClassMethod> methods = new HashSet<ClassMethod>();
    private byte[] bytecode;
    private static Method defineClass1;
    private static Method defineClass2;

    public ClassFile(String name, String superclass, String ... interfaces) {
        this.version = 50;
        this.name = name.replace('/', '.');
        this.superclass = superclass;
        this.accessFlags = AccessFlag.of(32, 1);
        for (String i : interfaces) {
            this.interfaces.add(i);
        }
    }

    public void addInterface(String iface) {
        this.interfaces.add(iface);
    }

    public ClassField addField(int accessFlags, String name, String descriptor) {
        return this.addField(accessFlags, name, descriptor, null);
    }

    public ClassField addField(int accessFlags, String name, String descriptor, String signature) {
        ClassField field = new ClassField((short)accessFlags, name, descriptor, signature, this, this.constPool);
        if (this.fields.contains(field)) {
            throw new DuplicateMemberException("Field  already exists. Field: " + name + " Descriptor:" + signature);
        }
        this.fields.add(field);
        return field;
    }

    public ClassField addField(int accessFlags, String name, Class<?> type) {
        return this.addField(accessFlags, name, DescriptorUtils.makeDescriptor(type));
    }

    public ClassField addField(int accessFlags, String name, Class<?> type, Type genericType) {
        return this.addField(accessFlags, name, DescriptorUtils.makeDescriptor(type), null);
    }

    public ClassField addField(Field field) {
        return this.addField((int)((short)field.getModifiers()), field.getName(), field.getType(), field.getGenericType());
    }

    public ClassMethod addMethod(int accessFlags, String name, String returnType, String ... parameters) {
        ClassMethod method = new ClassMethod(name, returnType, parameters, accessFlags, this);
        if (this.methods.contains(method)) {
            throw new DuplicateMemberException("Method  already exists. Method: " + name + " Parameters:" + Arrays.toString(parameters) + " Return Type: " + returnType);
        }
        this.methods.add(method);
        return method;
    }

    public ClassMethod addMethod(Method method) {
        ClassMethod classMethod = this.addMethod(method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF, method.getName(), DescriptorUtils.makeDescriptor(method.getReturnType()), DescriptorUtils.parameterDescriptors(method.getParameterTypes()));
        for (Class<?> e : method.getExceptionTypes()) {
            classMethod.addCheckedExceptions(e);
        }
        return classMethod;
    }

    public ClassMethod addConstructor(Constructor<?> method) {
        ClassMethod classMethod = this.addMethod(method.getModifiers(), "<init>", "V", DescriptorUtils.parameterDescriptors(method.getParameterTypes()));
        for (Class<?> e : method.getExceptionTypes()) {
            classMethod.addCheckedExceptions(e);
        }
        return classMethod;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        short nameIndex = this.constPool.addClassEntry(this.name);
        short superClassIndex = this.constPool.addClassEntry(this.superclass);
        ArrayList<Short> interfaceIndexes = new ArrayList<Short>(this.interfaces.size());
        for (String i : this.interfaces) {
            interfaceIndexes.add(this.constPool.addClassEntry(i));
        }
        stream.writeInt(-889275714);
        stream.writeInt(this.version);
        this.constPool.write(stream);
        stream.writeShort(this.accessFlags);
        stream.writeShort(nameIndex);
        stream.writeShort(superClassIndex);
        stream.writeShort(interfaceIndexes.size());
        Iterator<Object> i$ = interfaceIndexes.iterator();
        while (i$.hasNext()) {
            short i = (Short)((Object)i$.next());
            stream.writeShort(i);
        }
        stream.writeShort(this.fields.size());
        for (ClassField field : this.fields) {
            field.write(stream);
        }
        stream.writeShort(this.methods.size());
        for (ClassMethod method : this.methods) {
            method.write(stream);
        }
        stream.writeShort(0);
    }

    public Class<?> define(ClassLoader loader) {
        return this.define(loader, null);
    }

    public Class<?> define(ClassLoader loader, ProtectionDomain domain) {
        try {
            Object[] args;
            Method method;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                String packageName = this.name.substring(0, this.name.lastIndexOf(46));
                RuntimePermission permission = new RuntimePermission("defineClassInPackage." + packageName);
                sm.checkPermission(permission);
            }
            byte[] b = this.toBytecode();
            if (domain == null) {
                method = defineClass1;
                args = new Object[]{this.name.replace('/', '.'), b, new Integer(0), new Integer(b.length)};
            } else {
                method = defineClass2;
                args = new Object[]{this.name.replace('/', '.'), b, new Integer(0), new Integer(b.length), domain};
            }
            Class clazz = (Class)method.invoke((Object)loader, args);
            return clazz;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toBytecode() {
        if (this.bytecode == null) {
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bytes);
                this.write(out);
                this.bytecode = bytes.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.bytecode;
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public String getDescriptor() {
        return 'L' + this.name + ';';
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Class<?> cl = Class.forName("java.lang.ClassLoader", false, null);
                    defineClass1 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    defineClass1.setAccessible(true);
                    defineClass2 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    defineClass2.setAccessible(true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("cannot initialize ClassFile", pae.getException());
        }
    }
}

