/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.WritableEntry;
import org.jboss.classfilewriter.attributes.Attribute;
import org.jboss.classfilewriter.attributes.ExceptionsAttribute;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.constpool.ConstPool;
import org.jboss.classfilewriter.util.DescriptorUtils;

public class ClassMethod
implements WritableEntry {
    private final String returnType;
    private final String[] parameters;
    private final String name;
    private final String descriptor;
    private final int accessFlags;
    private final ClassFile classFile;
    private final short nameIndex;
    private final short descriptorIndex;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final CodeAttribute codeAttribute;
    private final ExceptionsAttribute exceptionsAttribute;
    private final boolean constructor;

    ClassMethod(String name, String returnType, String[] parameters, int accessFlags, ClassFile classFile) {
        ConstPool constPool = classFile.getConstPool();
        this.classFile = classFile;
        this.returnType = DescriptorUtils.validateDescriptor(returnType);
        this.parameters = parameters;
        this.name = name;
        this.descriptor = DescriptorUtils.methodDescriptor(parameters, returnType);
        this.accessFlags = accessFlags;
        this.nameIndex = constPool.addUtf8Entry(name);
        this.descriptorIndex = constPool.addUtf8Entry(this.descriptor);
        this.constructor = name.equals("<init>");
        this.exceptionsAttribute = new ExceptionsAttribute(constPool);
        this.attributes.add(this.exceptionsAttribute);
        if (Modifier.isAbstract(accessFlags)) {
            this.codeAttribute = null;
        } else {
            this.codeAttribute = new CodeAttribute(this, constPool);
            this.attributes.add(this.codeAttribute);
        }
        for (String param : this.parameters) {
            DescriptorUtils.validateDescriptor(param);
        }
    }

    public void addCheckedExceptions(Class<? extends Exception> ... exceptions) {
        for (Class<? extends Exception> exception : exceptions) {
            this.exceptionsAttribute.addExceptionClass(exception.getName());
        }
    }

    public void addCheckedExceptions(String ... exceptions) {
        for (String exception : exceptions) {
            this.exceptionsAttribute.addExceptionClass(exception);
        }
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        stream.writeShort(this.accessFlags);
        stream.writeShort(this.nameIndex);
        stream.writeShort(this.descriptorIndex);
        stream.writeShort(this.attributes.size());
        for (Attribute attribute : this.attributes) {
            attribute.write(stream);
        }
    }

    public CodeAttribute getCodeAttribute() {
        return this.codeAttribute;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.accessFlags);
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.accessFlags;
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMethod other = (ClassMethod)obj;
        if (this.accessFlags != other.accessFlags) {
            return false;
        }
        if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

