/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.annotations;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jboss.classfilewriter.annotations.AnnotationValue;
import org.jboss.classfilewriter.constpool.ConstPool;

public class BooleanAnnotationValue
extends AnnotationValue {
    private final int valueIndex;
    private final boolean value;

    public BooleanAnnotationValue(ConstPool constPool, String name, boolean value) {
        super(constPool, name);
        this.value = value;
        this.valueIndex = constPool.addIntegerEntry(value ? 1 : 0);
    }

    @Override
    public char getTag() {
        return 'Z';
    }

    @Override
    public void writeData(DataOutputStream stream) throws IOException {
        stream.writeShort(this.valueIndex);
    }

    public boolean getValue() {
        return this.value;
    }
}

