/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.annotations;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.classfilewriter.WritableEntry;
import org.jboss.classfilewriter.annotations.AnnotationValue;
import org.jboss.classfilewriter.constpool.ConstPool;

public class ClassAnnotation
implements WritableEntry {
    private final String type;
    private final int typeIndex;
    private final List<AnnotationValue> annotationValues;

    public ClassAnnotation(ConstPool constPool, String type, List<AnnotationValue> annotationValues) {
        this.type = type;
        this.typeIndex = constPool.addClassEntry(type);
        this.annotationValues = new ArrayList<AnnotationValue>(annotationValues);
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        stream.writeShort(this.typeIndex);
        stream.writeShort(this.annotationValues.size());
        for (AnnotationValue value : this.annotationValues) {
            value.write(stream);
        }
    }

    public String getType() {
        return this.type;
    }

    public List<AnnotationValue> getAnnotationValues() {
        return this.annotationValues;
    }
}

