/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.annotations;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jboss.classfilewriter.annotations.AnnotationValue;
import org.jboss.classfilewriter.constpool.ConstPool;

public class LongAnnotationValue
extends AnnotationValue {
    private final int valueIndex;
    private final long value;

    public LongAnnotationValue(ConstPool constPool, String name, long value) {
        super(constPool, name);
        this.value = value;
        this.valueIndex = constPool.addLongEntry(value);
    }

    @Override
    public char getTag() {
        return 'J';
    }

    @Override
    public void writeData(DataOutputStream stream) throws IOException {
        stream.writeShort(this.valueIndex);
    }

    public long getValue() {
        return this.value;
    }
}

