/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.classpool.plugins.jbosscl.as;

import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classpool.plugins.jbosscl.ParentUnitLoaderFinder;
import org.jboss.deployers.plugins.classloading.AbstractDeploymentClassLoaderPolicyModule;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/**
 * In AS AbstractDeploymentClassLoaderPolicyModule is only available after deploying deployers.xml 
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class AbstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder implements ParentUnitLoaderFinder
{
   public ClassLoader findParentUnitLoader(Module module)
   {
      if (module instanceof AbstractDeploymentClassLoaderPolicyModule == false)
         throw new IllegalArgumentException(module + " is not an AbstractDeploymentClassLoaderPolicyModule");
      {
         DeploymentUnit unit = AbstractDeploymentClassLoaderPolicyModule.class.cast(module).getDeploymentUnit();
         return unit.isTopLevel() ? null : unit.getParent().getClassLoader();
      }
   }

   public boolean handle(Module module)
   {
      return module instanceof AbstractDeploymentClassLoaderPolicyModule;
   }

}
