/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.jbosscl;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.classpool.plugins.jbosscl.JBoss5ClassPool;
import org.jboss.classpool.spi.AbstractClassPool;
import org.jboss.classpool.spi.ClassPoolRepository;

public class ScopedJBoss5ClassPool
extends JBoss5ClassPool {
    ThreadLocal<ClassPool> lastPool = new ThreadLocal();
    WeakReference<ClassLoaderDomain> domainRef;
    ClassPool parentDomainPool;

    public ScopedJBoss5ClassPool(ClassLoader cl, ClassPool src, ClassPool parentDomainPool, ScopedClassPoolRepository repository, URL tmpURL, boolean parentFirst, ClassLoaderDomain domain) {
        super(cl, src, repository, tmpURL);
        this.childFirstLookup = !parentFirst;
        this.parentDomainPool = parentDomainPool;
        this.domainRef = new WeakReference<ClassLoaderDomain>(domain);
        this.logger.debug((Object)("Created new ScopedJBoss5ClasPool for " + cl + ", with parent: " + src + ", parentDomain: " + parentDomainPool + ", parentFirst: " + parentFirst));
    }

    private URL getResourceUrlForClass(String resourcename) {
        ClassLoaderDomain domain = (ClassLoaderDomain)this.domainRef.get();
        return domain.getResource(resourcename);
    }

    private boolean isMine(URL myURL, String resourceName) {
        if (myURL == null) {
            return false;
        }
        ClassLoaderDomain domain = (ClassLoaderDomain)this.domainRef.get();
        Loader parent = domain.getParent();
        URL parentURL = parent.getResource(resourceName);
        if (parentURL == null) {
            return true;
        }
        return !myURL.equals(parentURL);
    }

    protected synchronized CtClass get0(String classname, boolean useCache) throws NotFoundException {
        CtClass clazz = null;
        if (useCache && (clazz = this.getCached(classname)) != null) {
            return clazz;
        }
        if (!this.childFirstLookup) {
            if (this.parentDomainPool != null && (clazz = this.performGet(this.parentDomainPool, classname)) != null) {
                return clazz;
            }
            if (this.parent != null && (clazz = this.performGet(this.parent, classname)) != null) {
                return clazz;
            }
        }
        if ((clazz = this.createCtClass(classname, useCache)) != null) {
            if (useCache) {
                this.cacheCtClass(clazz.getName(), clazz, false);
            }
            return clazz;
        }
        if (this.childFirstLookup) {
            if (this.parent != null && (clazz = this.performGet(this.parent, classname)) != null) {
                return clazz;
            }
            if (this.parentDomainPool != null && (clazz = this.performGet(this.parentDomainPool, classname)) != null) {
                return clazz;
            }
        }
        return clazz;
    }

    private CtClass performGet(ClassPool pool, String classname) {
        try {
            return pool.getCtClass(classname);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public CtClass getCached(String classname) {
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)("getCached() " + classname));
        }
        if (classname == null) {
            if (trace) {
                this.logger.trace((Object)"getCached() returning null (classname == null)");
            }
            return null;
        }
        if (this.isUnloadedClassLoader()) {
            if (trace) {
                this.logger.trace((Object)"getCached() returning null (unloaded)");
            }
            return null;
        }
        if (this.generatedClasses.get(classname) != null) {
            if (trace) {
                this.logger.trace((Object)"getCached() In generated classes - check super");
            }
            return super.getCached(classname);
        }
        String resourcename = this.getResourceName(classname);
        URL url = this.getResourceUrlForClass(resourcename);
        if (this.isMine(url, resourcename)) {
            if (this.childFirstLookup) {
                CtClass clazz = super.getCachedLocally(classname);
                if (clazz == null) {
                    if (trace) {
                        this.logger.trace((Object)("getCached() Creating my class " + classname));
                    }
                    if ((clazz = this.createCtClass(classname, false)) != null) {
                        this.lockInCache(clazz);
                    }
                }
                if (clazz != null) {
                    if (trace) {
                        this.logger.trace((Object)("getCached() Returning my class " + classname));
                    }
                    return clazz;
                }
            }
            if (trace) {
                this.logger.trace((Object)("getCached() Checking super for my class " + classname));
            }
            return super.getCached(classname);
        }
        if (url == null) {
            if (trace) {
                this.logger.trace((Object)("getCached() Checking super for my class " + classname + " (no url)"));
            }
            return super.getCached(classname);
        }
        try {
            ClassPool pool = this.getCorrectPoolForResource(classname, resourcename, url, trace);
            if (trace) {
                this.logger.trace((Object)("getCached() Found pool for class " + classname + " " + pool));
            }
            if (pool != this.lastPool.get()) {
                this.lastPool.set(pool);
                CtClass found = pool.get(classname);
                if (trace) {
                    this.logger.trace((Object)("getCached() Found clazz " + classname + " in " + pool + " : " + found));
                }
                CtClass ctClass = found;
                return ctClass;
            }
        }
        catch (NotFoundException e) {
        }
        catch (StackOverflowError e) {
            throw e;
        }
        finally {
            this.lastPool.set(null);
        }
        return null;
    }

    protected boolean includeInGlobalSearch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getCorrectPoolForResource(String classname, String resourceName, URL url, boolean trace) {
        Map map = ClassPoolRepository.getInstance().getRegisteredCLs();
        synchronized (map) {
            ArrayList<AbstractClassPool> noAnnotationURLClassLoaderPools = null;
            ClassPoolRepository classPoolRepository = ClassPoolRepository.getInstance();
            for (ClassPool classPool : classPoolRepository.getRegisteredCLs().values()) {
                AbstractClassPool candidate = (AbstractClassPool)classPool;
                if (candidate.isUnloadedClassLoader()) {
                    classPoolRepository.unregisterClassLoader(candidate.getClassLoader());
                    continue;
                }
                if (candidate.getClassLoader() instanceof RealClassLoader) {
                    RealClassLoader bcl = (RealClassLoader)candidate.getClassLoader();
                    URL foundUrl = bcl.getResourceLocally(resourceName);
                    if (foundUrl == null || !url.equals(foundUrl)) continue;
                    if (trace) {
                        this.logger.trace((Object)("getCorrectPoolForResource() Candidate classloader " + bcl + " has local resource " + foundUrl));
                    }
                    return candidate;
                }
                if (!this.isInstanceOfNoAnnotationURLClassLoader(candidate.getClassLoader())) continue;
                if (noAnnotationURLClassLoaderPools == null) {
                    noAnnotationURLClassLoaderPools = new ArrayList<AbstractClassPool>();
                }
                noAnnotationURLClassLoaderPools.add(candidate);
            }
            if (noAnnotationURLClassLoaderPools != null) {
                for (ClassPool classPool : noAnnotationURLClassLoaderPools) {
                    try {
                        classPool.get(classname);
                        if (trace) {
                            this.logger.trace((Object)("getCorrectPoolForResource(() Found  " + classname + " (no url)"));
                        }
                        return classPool;
                    }
                    catch (NotFoundException ignoreTryNext) {
                    }
                }
            }
        }
        return this.createTempPool();
    }

    private ClassPool createTempPool() {
        ClassLoader loader = this.getClass().getClassLoader();
        ClassPool pool = ClassPoolRepository.getInstance().registerClassLoader(loader);
        return ClassPoolRepository.getInstance().getClassPoolFactory().create(pool, (ScopedClassPoolRepository)ClassPoolRepository.getInstance());
    }

    private boolean isInstanceOfNoAnnotationURLClassLoader(ClassLoader loader) {
        if (loader == null) {
            return false;
        }
        for (Class<?> parent = loader.getClass(); parent != null; parent = parent.getSuperclass()) {
            if (!"NoAnnotationURLClassLoader".equals(parent.getSimpleName())) continue;
            return true;
        }
        return false;
    }
}

