/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.jbosscl;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.base.BaseClassLoaderSource;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classpool.plugins.jbosscl.DomainRegistry;
import org.jboss.classpool.plugins.jbosscl.SecurityActions;
import org.jboss.deployers.plugins.classloading.AbstractDeploymentClassLoaderPolicyModule;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public class VFSClassLoaderDomainRegistry
implements DomainRegistry {
    protected static final ClassLoaderDomain domain = new ClassLoaderDomain("NOT_USED_PLACEHOLDER");
    private static final VFSClassLoaderDomainRegistry instance = new VFSClassLoaderDomainRegistry();
    private ClassLoaderSystem system;
    private ClassLoaderDomain defaultDomain;
    protected Map<ClassLoader, WeakReference<ClassLoaderDomain>> classLoaderDomainsByLoader = new WeakHashMap<ClassLoader, WeakReference<ClassLoaderDomain>>();
    private Map<ClassLoader, WeakReference<ClassLoader>> classLoaderUnitParents = new WeakHashMap<ClassLoader, WeakReference<ClassLoader>>();
    private Map<ClassLoader, WeakReference<Module>> classLoaderModules = new WeakHashMap<ClassLoader, WeakReference<Module>>();
    private Map<Module, WeakReference<ClassLoader>> moduleClassLoaders = new WeakHashMap<Module, WeakReference<ClassLoader>>();
    protected Map<ClassLoaderDomain, Integer> classLoaderDomainReferenceCounts = new WeakHashMap<ClassLoaderDomain, Integer>();

    public static final VFSClassLoaderDomainRegistry getInstance() {
        return instance;
    }

    protected VFSClassLoaderDomainRegistry() {
    }

    public synchronized void setSystem(ClassLoaderSystem system) {
        this.system = system;
    }

    public synchronized void setDefaultDomain(ClassLoaderDomain domain) {
        this.defaultDomain = domain;
    }

    public synchronized ClassLoaderSystem getSystem() {
        if (this.system == null) {
            this.system = ClassLoaderSystem.getInstance();
        }
        return this.system;
    }

    public synchronized ClassLoaderDomain getDefaultDomain() {
        if (this.defaultDomain == null) {
            this.defaultDomain = this.getSystem().getDefaultDomain();
        }
        return this.defaultDomain;
    }

    public synchronized boolean initMapsForModule(Module module) {
        ClassLoader parentUnitLoader;
        ClassLoader loader = ClassLoading.getClassLoaderForModule((Module)module);
        if (loader == (parentUnitLoader = this.findParentUnitLoader(module))) {
            throw new IllegalArgumentException("initMapsForLoader() should only be called if parentUnitLoader is different from loader");
        }
        ClassLoaderSystem system = this.getSystem();
        String domainName = module.getDeterminedDomainName();
        ClassLoaderDomain clDomain = system.getDomain(domainName);
        this.validateInitMaps(loader, clDomain, module, parentUnitLoader);
        boolean ret = false;
        if (!this.classLoaderDomainsByLoader.containsKey(loader)) {
            Integer count = this.classLoaderDomainReferenceCounts.get(clDomain);
            int cnt = count == null ? 0 : count;
            this.classLoaderDomainReferenceCounts.put(clDomain, cnt);
            this.classLoaderDomainsByLoader.put(loader, new WeakReference<ClassLoaderDomain>(clDomain));
            this.classLoaderUnitParents.put(loader, new WeakReference<ClassLoader>(parentUnitLoader));
            this.classLoaderModules.put(loader, new WeakReference<Module>(module));
            this.moduleClassLoaders.put(module, new WeakReference<ClassLoader>(loader));
            ret = true;
            this.initMapsDone(loader, clDomain, module, parentUnitLoader);
        }
        return ret;
    }

    protected void validateInitMaps(ClassLoader loader, ClassLoaderDomain loaderDomain, Module module, ClassLoader parentUnitLoader) {
    }

    protected void initMapsDone(ClassLoader loader, ClassLoaderDomain loaderDomain, Module module, ClassLoader parentUnitLoader) {
    }

    public synchronized void cleanupModule(Module module) {
        ClassLoader loader = this.getClassLoader(module);
        this.validateCleanupLoader(loader);
        WeakReference<ClassLoaderDomain> clDomainRef = this.classLoaderDomainsByLoader.remove(loader);
        ClassLoaderDomain clDomain = clDomainRef == null ? null : (ClassLoaderDomain)clDomainRef.get();
        int cnt = 0;
        if (clDomain != null) {
            Integer count = this.classLoaderDomainReferenceCounts.get(clDomain);
            int n = cnt = count == null ? 0 : count;
            if (cnt > 0) {
                --cnt;
            }
            if (cnt == 0) {
                this.classLoaderDomainReferenceCounts.remove(clDomain);
            } else {
                this.classLoaderDomainReferenceCounts.put(clDomain, ++cnt);
            }
            this.classLoaderUnitParents.remove(loader);
            this.classLoaderModules.remove(loader);
            this.moduleClassLoaders.remove(module);
        }
        this.cleanupLoaderDone(loader, clDomain, cnt);
    }

    protected void validateCleanupLoader(ClassLoader loader) {
    }

    protected void cleanupLoaderDone(ClassLoader loader, ClassLoaderDomain loaderDomain, int domainReferences) {
    }

    public synchronized ClassLoaderDomain getClassLoaderDomainForLoader(ClassLoader cl) {
        ClassLoaderDomain domain;
        WeakReference<ClassLoaderDomain> clDomainRef = this.classLoaderDomainsByLoader.get(cl);
        if (clDomainRef != null) {
            return (ClassLoaderDomain)clDomainRef.get();
        }
        ClassLoader parent = SecurityActions.getParent(cl);
        if (parent != null && (domain = this.getClassLoaderDomainForLoader(parent)) != null) {
            this.classLoaderDomainsByLoader.put(parent, new WeakReference<ClassLoaderDomain>(domain));
            return domain;
        }
        return null;
    }

    public synchronized ClassLoader getParentUnitLoader(ClassLoader loader) {
        WeakReference<ClassLoader> parentRef = this.classLoaderUnitParents.get(loader);
        if (parentRef != null) {
            return (ClassLoader)parentRef.get();
        }
        return null;
    }

    public synchronized Module getModule(ClassLoader loader) {
        WeakReference<Module> moduleRef = this.classLoaderModules.get(loader);
        if (moduleRef != null) {
            return (Module)moduleRef.get();
        }
        return null;
    }

    public synchronized ClassLoader getClassLoader(Module module) {
        WeakReference<ClassLoader> loaderRef = this.moduleClassLoaders.get(module);
        if (loaderRef != null) {
            return (ClassLoader)loaderRef.get();
        }
        return null;
    }

    private ClassLoader findParentUnitLoader(Module module) {
        if (module instanceof AbstractDeploymentClassLoaderPolicyModule) {
            DeploymentUnit unit = ((AbstractDeploymentClassLoaderPolicyModule)AbstractDeploymentClassLoaderPolicyModule.class.cast(module)).getDeploymentUnit();
            return unit.isTopLevel() ? null : unit.getParent().getClassLoader();
        }
        ClassLoaderDomain domain = ClassLoaderSystem.getInstance().getDomain(module.getDeterminedDomainName());
        if (domain.getParent() instanceof ClassLoaderToLoaderAdapter) {
            ClassLoaderToLoaderAdapter cp2la = (ClassLoaderToLoaderAdapter)domain.getParent();
            return SecurityActions.getClassLoader((BaseClassLoaderSource)cp2la);
        }
        return null;
    }
}

