/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.classpool.plugins.jbosscl;

import javassist.ClassPool;

import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.classpool.domain.ClassPoolToClassPoolDomainAdapter;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @author <a href="mailto:flavia.rainone@jboss.com">Flavia Rainone</a>
 * @version $Revision: 101497 $
 */
class JBossClClassPoolToClassPoolDomainAdapter extends ClassPoolToClassPoolDomainAdapter
{
   public JBossClClassPoolToClassPoolDomainAdapter()
   {
      super();
   }
   
   public JBossClClassPoolToClassPoolDomainAdapter(ClassPool classPool)
   {
      super(classPool);
   }
   
   // TODO JBREFLECT-65 FIXME  this methd shouldn't be returning always the app classloader
   @Override
   public ClassPool initialiseParentClassLoader()
   {
      return JBossClDelegatingClassPoolRepository.getInstance().registerClassLoader(BaseClassLoaderDomain.class.getClassLoader());
   }
}
