/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.classpool.plugins.jbosscl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.ModuleRegistry;
import org.jboss.logging.Logger;

/**
 * Use with org.jboss.classpool.jbosscl.JBossClDelegatingClassPoolFactory
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @author <a href="ales.justin@jboss.com">Ales Justin</a>
 * @author <a href="flavia.rainone@jboss.com">Flavia Rainone</a>
 * @version $Revision: 97735 $
 */
public class RegisterModuleCallback implements ModuleRegistry
{
   Logger logger = Logger.getLogger(this.getClass());
   
   private Set<Module> registeredModules = new HashSet<Module>();
   private Set<Module> unregisteredModules = new HashSet<Module>();
   private DomainRegistry domainRegistry;
   
   public RegisterModuleCallback(DomainRegistry domainRegistry)
   {
      this.domainRegistry = domainRegistry;
   }
   
   public synchronized void addModule(Module module)
   {
      if (logger.isTraceEnabled())
      {
         logger.trace("Adding module " + module);
      }
      unregisteredModules.add(module);
   }

   public synchronized void removeModule(Module module)
   {
      
      ClassLoader classLoader = domainRegistry.getClassLoader(module);
      if (logger.isTraceEnabled())
      {
         logger.trace("Removing module " + module + " and class loader " + classLoader);
      }
      JBossClDelegatingClassPoolRepository.getInstance().unregisterClassLoader(classLoader, module);
      domainRegistry.cleanupModule(module);
      registeredModules.remove(module);
      unregisteredModules.remove(module);
   }
   
   public synchronized void registerModule(Module module)
   {
      if (logger.isTraceEnabled())
      {
         logger.trace("Registering module " + module);
      }
      
      registeredModules.add(module);
      unregisteredModules.remove(module);
      
      domainRegistry.initMapsForModule(module);
   }
   
   public synchronized Collection<Module> getUnregisteredModules()
   {
      return new ArrayList<Module>(unregisteredModules);
   }
}