/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.jbosscl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import javassist.ClassPool;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomainRegistry;
import org.jboss.classpool.plugins.NonDelegatingClassPool;
import org.jboss.classpool.plugins.jbosscl.DomainRegistry;
import org.jboss.classpool.plugins.jbosscl.JBossClClassPoolDomain;
import org.jboss.classpool.plugins.jbosscl.JBossClDelegatingClassPool;
import org.jboss.classpool.plugins.jbosscl.JBossClRegistryHandler;
import org.jboss.classpool.plugins.jbosscl.RegisterModuleCallback;
import org.jboss.classpool.plugins.temp.TempClassPoolFactory;
import org.jboss.classpool.scoped.ScopedClassPoolFactory;
import org.jboss.classpool.scoped.ScopedClassPoolRepository;
import org.jboss.classpool.spi.AbstractClassPool;
import org.jboss.classpool.spi.AbstractClassPoolFactory;
import org.jboss.classpool.spi.ClassLoaderRegistryHandler;
import org.jboss.classpool.spi.ClassLoaderRegistryHandlerFactory;

public class JBossClDelegatingClassPoolFactory
extends TempClassPoolFactory
implements ClassLoaderRegistryHandlerFactory,
ScopedClassPoolFactory {
    private final DomainRegistry registry;
    private final RegisterModuleCallback registerModuleCallback;
    private Collection<ClassLoader> currentClassLoaders = new HashSet<ClassLoader>();

    public JBossClDelegatingClassPoolFactory(DomainRegistry registry, RegisterModuleCallback registerModuleCallback) {
        this.registry = registry;
        this.registerModuleCallback = registerModuleCallback;
    }

    public ClassLoaderRegistryHandler create(ClassLoaderRegistryHandler successor) {
        JBossClRegistryHandler handler = JBossClRegistryHandler.getInstance();
        handler.setSuccessor(successor);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AbstractClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        if (this.currentClassLoaders.contains(cl)) {
            return null;
        }
        this.currentClassLoaders.add(cl);
        try {
            ClassPool parent = this.getCreateParentClassPools(cl, src, repository);
            if (cl instanceof RealClassLoader) {
                Module module = this.registry.getModule(cl);
                if (module == null) {
                    module = this.getModuleForClassLoader(cl);
                }
                this.registerModuleCallback.registerModule(module);
                this.registerBootstrapLoaders(module, repository);
                ClassPoolDomain domain = this.getDomain(module, cl, repository);
                if (domain == null) {
                    AbstractClassPool abstractClassPool = null;
                    return abstractClassPool;
                }
                JBossClDelegatingClassPool jBossClDelegatingClassPool = new JBossClDelegatingClassPool(domain, cl, parent, repository, module, this.registerModuleCallback);
                return jBossClDelegatingClassPool;
            }
            if (parent == null) {
                parent = AbstractClassPoolFactory.getSystemClassPool();
            }
            NonDelegatingClassPool nonDelegatingClassPool = new NonDelegatingClassPool(cl, parent, repository, true);
            return nonDelegatingClassPool;
        }
        finally {
            this.currentClassLoaders.remove(cl);
        }
    }

    private ClassPoolDomain getDomain(Module module, ClassLoader cl, ScopedClassPoolRepository repository) {
        ClassLoaderDomain domain = null;
        ClassLoaderSystem sys = this.registry.getSystem();
        if (module != null && module.getDeterminedParentDomainName() != null) {
            domain = sys.getDomain(module.getDeterminedDomainName());
        }
        if (domain == null) {
            domain = this.registry.getDefaultDomain();
        }
        return this.getDomain(cl, domain, sys, repository);
    }

    private ClassPoolDomain getDomain(ClassLoader cl, ClassLoaderDomain domain, ClassLoaderSystem sys, ScopedClassPoolRepository repository) {
        Object poolDomain = ClassPoolDomainRegistry.getInstance().getDomain((Object)domain);
        if (poolDomain == null) {
            String parentDomainName = domain.getParentDomainName();
            if (parentDomainName != null) {
                ClassLoaderDomain parentDomain = sys.getDomain(parentDomainName);
                if (parentDomain == null) {
                    throw new RuntimeException("No domain found, domain name: " + parentDomainName);
                }
                ClassPoolDomain parentPoolDomain = this.getDomain(null, parentDomain, sys, repository);
                poolDomain = new JBossClClassPoolDomain(domain.getName(), parentPoolDomain, domain.getParentPolicy(), this.registry);
            } else {
                ClassLoader parentUnitLoader = this.registry.getParentUnitLoader(cl);
                if (this.currentClassLoaders.contains(parentUnitLoader)) {
                    return null;
                }
                ClassPool parentUnitPool = parentUnitLoader == null ? null : repository.registerClassLoader(parentUnitLoader);
                poolDomain = parentUnitPool == null ? new JBossClClassPoolDomain(domain.getName(), domain.getParentPolicy(), this.registry) : new JBossClClassPoolDomain(domain.getName(), parentUnitPool, domain.getParentPolicy(), this.registry);
            }
            ClassPoolDomainRegistry.getInstance().addClassPoolDomain((Object)domain, poolDomain);
        }
        return poolDomain;
    }

    private void registerBootstrapLoaders(Module skip, ScopedClassPoolRepository repository) {
        Collection<Module> unregistered = this.registerModuleCallback.getUnregisteredModules();
        if (unregistered.size() > 0) {
            for (Module module : unregistered) {
                ClassPool classPool;
                ClassLoader loader;
                if (module == skip || (loader = this.getClassLoaderForModule(module)) == null || this.currentClassLoaders.contains(loader) || (classPool = repository.registerClassLoader(loader)) != null) continue;
                repository.unregisterClassLoader(loader);
            }
        }
    }

    private ClassLoader getClassLoaderForModule(final Module module) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoading.getClassLoaderForModule((Module)module);
            }
        });
    }

    private Module getModuleForClassLoader(final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<Module>(){

            @Override
            public Module run() {
                return ClassLoading.getModuleForClassLoader((ClassLoader)classLoader);
            }
        });
    }
}

