/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.ucl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javassist.ClassPool;
import org.jboss.classpool.base.BaseClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomainRegistry;
import org.jboss.classpool.plugins.NonDelegatingClassPool;
import org.jboss.classpool.plugins.temp.TempClassPoolFactory;
import org.jboss.classpool.plugins.ucl.UclDelegatingClassPool;
import org.jboss.classpool.scoped.ScopedClassPoolRepository;
import org.jboss.classpool.spi.AbstractClassPool;
import org.jboss.classpool.spi.AbstractClassPoolFactory;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;

public class UclDelegatingClassPoolFactory
extends TempClassPoolFactory {
    private ClassPoolDomain mainDomain;
    protected File tmpClassesDir;

    public UclDelegatingClassPoolFactory(File tmpClassesDir) throws IOException {
        System.out.println("TMP CLASSES DIR: " + tmpClassesDir);
        this.tmpClassesDir = tmpClassesDir;
    }

    public synchronized AbstractClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        ClassPool parent = this.getCreateParentClassPools(cl, src, repository);
        if (cl instanceof RepositoryClassLoader) {
            ClassPoolDomain domain = this.getDomain((RepositoryClassLoader)cl);
            File tempdir = this.getTempDirectory(cl);
            URL tmpCP = this.createURLAndAddToLoader(cl, tempdir);
            return new UclDelegatingClassPool(domain, cl, parent, repository, tempdir, tmpCP);
        }
        if (parent == null) {
            parent = AbstractClassPoolFactory.getSystemClassPool();
        }
        return new NonDelegatingClassPool(cl, parent, repository, true);
    }

    private ClassPoolDomain getDomain(RepositoryClassLoader cl) {
        LoaderRepository loaderRepository = cl.getLoaderRepository();
        ClassPoolDomainRegistry registry = ClassPoolDomainRegistry.getInstance();
        ClassPoolDomain domain = registry.getDomain((Object)loaderRepository);
        if (domain == null) {
            if (loaderRepository instanceof HeirarchicalLoaderRepository3) {
                boolean parentFirst = ((HeirarchicalLoaderRepository3)loaderRepository).getUseParentFirst();
                domain = new BaseClassPoolDomain("Scoped" + System.identityHashCode(loaderRepository), this.mainDomain, parentFirst);
            } else {
                if (this.mainDomain == null) {
                    this.mainDomain = domain = new BaseClassPoolDomain("JMImplementation:service=LoaderRepository,name=Default", null, false);
                } else {
                    domain = this.mainDomain;
                }
                registry.addClassPoolDomain((Object)loaderRepository, domain);
            }
        }
        return domain;
    }

    protected File getTempDirectory(ClassLoader cl) {
        File tempdir = null;
        int attempts = 0;
        IOException ex = null;
        while (tempdir == null && attempts < 5) {
            try {
                tempdir = this.createTempDir(cl);
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (tempdir == null) {
            throw new RuntimeException("", ex);
        }
        return tempdir;
    }

    public File createTempDir(ClassLoader cl) throws IOException {
        File tempdir = File.createTempFile("ucl", "", this.tmpClassesDir);
        if (!(tempdir.exists() && !tempdir.delete() || tempdir.mkdir())) {
            throw new IOException("Cannot create temp dir: " + tempdir);
        }
        tempdir.deleteOnExit();
        return tempdir;
    }

    private URL createURLAndAddToLoader(ClassLoader cl, File tempdir) {
        try {
            URL tmpURL = tempdir.toURI().toURL();
            URL tmpCP = new URL(tmpURL, "?dynamic=true");
            RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
            if (ucl.getLoaderRepository() != null) {
                ucl.addURL(tmpCP);
            }
            return tmpCP;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

