/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.ucl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javassist.ClassPool;
import org.jboss.classpool.plugins.AbstractJBossClassPoolFactory;
import org.jboss.classpool.plugins.ucl.JBossClassPool;
import org.jboss.classpool.plugins.ucl.ScopedJBossClassPool;
import org.jboss.classpool.plugins.ucl.ScopedRepositoryClassLoaderHelper;
import org.jboss.classpool.scoped.ScopedClassPoolRepository;
import org.jboss.classpool.spi.AbstractClassPool;
import org.jboss.mx.loading.RepositoryClassLoader;

public class JBossClassPoolFactory
extends AbstractJBossClassPoolFactory {
    protected File tmpClassesDir;

    public JBossClassPoolFactory(File tmpClassesDir) throws IOException {
        this.tmpClassesDir = tmpClassesDir;
    }

    public AbstractClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        ClassPool parent = this.getCreateParentClassPools(cl, src, repository);
        if (cl instanceof RepositoryClassLoader) {
            URL tmpCP;
            File tempdir = this.getTempDirectory(cl);
            try {
                tmpCP = this.createURLAndAddToLoader(cl, tempdir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (ScopedRepositoryClassLoaderHelper.isScopedClassLoader(cl)) {
                return new ScopedJBossClassPool(cl, parent, repository, tempdir, tmpCP);
            }
            return new JBossClassPool(cl, parent, repository, tempdir, tmpCP);
        }
        return new AbstractClassPool(cl, parent, repository);
    }

    protected File getTempDirectory(ClassLoader cl) {
        File tempdir = null;
        int attempts = 0;
        IOException ex = null;
        while (tempdir == null && attempts < 5) {
            try {
                tempdir = this.createTempDir(cl);
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (tempdir == null) {
            throw new RuntimeException("", ex);
        }
        return tempdir;
    }

    public File createTempDir(ClassLoader cl) throws IOException {
        File tempdir = File.createTempFile("ucl", "", this.tmpClassesDir);
        if (!(tempdir.exists() && !tempdir.delete() || tempdir.mkdir())) {
            throw new IOException("Cannot create temp dir: " + tempdir);
        }
        tempdir.deleteOnExit();
        return tempdir;
    }

    private URL createURLAndAddToLoader(ClassLoader cl, File tempdir) throws IOException {
        URL tmpURL = tempdir.toURI().toURL();
        URL tmpCP = new URL(tmpURL, "?dynamic=true");
        RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
        if (ucl.getLoaderRepository() != null) {
            ucl.addURL(tmpCP);
        }
        return tmpCP;
    }
}

