/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.support;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import junit.framework.Assert;
import org.jboss.classpool.spi.AbstractClassPool;
import org.jboss.classpool.spi.ClassPoolRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFactory {
    public static final String PACKAGE = "org.test.classpool.proxy";
    private static final String CLASS = "Proxy";
    private static int counter = 0;

    public static Object create(Class<?> parent, ClassLoader loader) throws Exception {
        String packageName = parent.getPackage().getName();
        packageName = !packageName.startsWith("java.") && !packageName.startsWith("sun.") ? packageName + "." : "org.test.classpool.proxy.";
        String className = packageName + CLASS + counter++;
        ClassPool pool = (ClassPool)ClassPoolRepository.getInstance().getRegisteredCLs().get(loader);
        try {
            ClassFactory.registerGeneratedClass(pool, className);
            CtClass ctClazz = pool.makeClass(packageName + CLASS + counter++);
            ctClazz.setSuperclass(pool.get(parent.getName()));
            Class clazz = pool.toClass(ctClazz);
            Assert.assertSame((Object)loader, (Object)clazz.getClassLoader());
            return clazz.newInstance();
        }
        catch (RuntimeException re) {
            ClassFactory.unregisterGeneratedClass(pool, className);
            throw re;
        }
    }

    public static CtClass create(ClassPool pool, String name) {
        ClassFactory.registerGeneratedClass(pool, name);
        return pool.makeClass(name);
    }

    public static CtClass createNested(CtClass outer, String name, boolean isStatic) throws CannotCompileException {
        String classname = outer.getName() + "$" + name;
        try {
            ClassFactory.registerGeneratedClass(outer.getClassPool(), classname);
            CtClass inner = outer.makeNestedClass(name, true);
            return inner;
        }
        catch (RuntimeException e) {
            ClassFactory.unregisterGeneratedClass(outer.getClassPool(), classname);
            throw e;
        }
    }

    private static void registerGeneratedClass(ClassPool pool, String name) {
        if (pool != null && pool instanceof AbstractClassPool) {
            ((AbstractClassPool)pool).registerGeneratedClass(name);
        }
    }

    private static void unregisterGeneratedClass(ClassPool pool, String name) {
        if (pool != null && pool instanceof AbstractClassPool) {
            ((AbstractClassPool)pool).doneGeneratingClass(name);
        }
    }
}

