/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.test;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.classpool.domain.AbstractClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.test.classpool.support.ClassFactory;
import org.jboss.test.classpool.support.SupportArchives;
import org.jboss.test.classpool.support.SupportClasses;
import org.jboss.test.classpool.test.ClassPoolTest;

public class ParentFirstDelegatingClassPoolTestCase
extends ClassPoolTest {
    public ParentFirstDelegatingClassPoolTestCase(String name) {
        super(name);
    }

    public void testClassInParentOnly() throws Exception {
        AbstractClassPoolDomain parent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", null, true);
        DelegatingClassPool parentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain child = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, true);
        DelegatingClassPool childPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_B_URL);
        this.accessClassInParentOnly((ClassPool)parentPool, (ClassPool)childPool);
        this.accessClassInParentOnly((ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessClassInParentOnly(ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = childPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)a2.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)a1, (Object)a2);
        CtClass b = childPool.get(SupportClasses.CLASS_B);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)childPool, (Object)b.getClassPool());
        try {
            parentPool.get(SupportClasses.CLASS_B);
            ParentFirstDelegatingClassPoolTestCase.fail((String)"Should not have been found");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        CtClass string = childPool.get(String.class.getName());
        ParentFirstDelegatingClassPoolTestCase.assertNotSame((String)"java.lang.String should be loaded by the parent pool", (Object)childPool, (Object)string.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)ClassPool.getDefault(), (Object)string.getClassPool());
    }

    public void testClassInGrandParentOnly() throws Exception {
        AbstractClassPoolDomain grandParent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("GRANDPARENT", null, true);
        DelegatingClassPool grandParentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)grandParent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain parent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", (ClassPoolDomain)grandParent, true);
        DelegatingClassPool parentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_B_URL);
        AbstractClassPoolDomain child = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, true);
        DelegatingClassPool childPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_B_URL);
        this.accessClassInGrandParentOnly((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
        this.accessClassInGrandParentOnly((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessClassInGrandParentOnly(ClassPool grandParentPool, ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = childPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a2.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)a1, (Object)a2);
        CtClass a3 = parentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a3.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)a2, (Object)a3);
        CtClass b1 = childPool.get(SupportClasses.CLASS_B);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)b1.getClassPool());
        CtClass b2 = childPool.get(SupportClasses.CLASS_B);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)b2.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)b1, (Object)b2);
        try {
            grandParentPool.get(SupportClasses.CLASS_B);
            ParentFirstDelegatingClassPoolTestCase.fail((String)"Should not have been found");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
    }

    public void testChildNotInParent() throws Exception {
        AbstractClassPoolDomain parent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", null, true);
        DelegatingClassPool parentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_B_URL);
        AbstractClassPoolDomain child = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, true);
        DelegatingClassPool childPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_A_URL);
        this.accessChildNotInParent((ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildNotInParent((ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildNotInParent(ClassPool parentPool, ClassPool childPool) throws Exception {
        try {
            parentPool.get(SupportClasses.CLASS_A);
            ParentFirstDelegatingClassPoolTestCase.fail((String)"Should not have been found");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        CtClass a = childPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)childPool, (Object)a.getClassPool());
    }

    public void testChildInParent() throws Exception {
        AbstractClassPoolDomain parent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", null, true);
        DelegatingClassPool parentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain child = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, true);
        DelegatingClassPool childPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_A_URL);
        this.accessChildInParent((ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildInParent((ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildInParent(ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = childPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)a2.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)a1, (Object)a2);
    }

    public void testChildInParentAndGrandParent() throws Exception {
        AbstractClassPoolDomain grandParent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("GRANDPARENT", null, true);
        DelegatingClassPool grandParentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)grandParent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain parent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", (ClassPoolDomain)grandParent, true);
        DelegatingClassPool parentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain child = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, true);
        DelegatingClassPool childPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_B_URL);
        this.accessChildInParentAndGrandParent((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildInParentAndGrandParent((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildInParentAndGrandParent(ClassPool grandParentPool, ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = childPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a2.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)a1, (Object)a2);
        CtClass a3 = grandParentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a3.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)a2, (Object)a3);
    }

    public void testChildInParentAndGrandParentFromTop() throws Exception {
        AbstractClassPoolDomain grandParent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("GRANDPARENT", null, true);
        DelegatingClassPool grandParentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)grandParent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain parent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", (ClassPoolDomain)grandParent, true);
        DelegatingClassPool parentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain child = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, true);
        DelegatingClassPool childPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_B_URL);
        this.accessChildInParentAndGrandParentFromTop((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildInParentAndGrandParentFromTop((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildInParentAndGrandParentFromTop(ClassPool grandParentPool, ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = grandParentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a2.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)a1, (Object)a2);
        CtClass a3 = childPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a3.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)a2, (Object)a3);
    }

    public void testChildInGrandParent() throws Exception {
        AbstractClassPoolDomain grandParent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("GRANDPARENT", null, true);
        DelegatingClassPool grandParentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)grandParent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain parent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", (ClassPoolDomain)grandParent, true);
        DelegatingClassPool parentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_B_URL);
        AbstractClassPoolDomain child = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, true);
        DelegatingClassPool childPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_A_URL);
        this.accessChildInGrandParent((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildInGrandParent((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildInGrandParent(ClassPool grandParentPool, ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = childPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a2.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)a1, (Object)a2);
        CtClass a3 = grandParentPool.get(SupportClasses.CLASS_A);
        ParentFirstDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a3.getClassPool());
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)a2, (Object)a3);
    }

    public void testGenerateSameNestedClassInChildAndParent() throws Exception {
        AbstractClassPoolDomain parent = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", null, false);
        DelegatingClassPool parentPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain child = ParentFirstDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, true);
        DelegatingClassPool childPool = ParentFirstDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_A_URL);
        CtClass parentA = parentPool.get(SupportClasses.CLASS_A);
        CtClass parentClazz = ClassFactory.createNested(parentA, "Test", true);
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)parentPool, (Object)parentClazz.getClassPool());
        Class parentClass = parentClazz.toClass();
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)parentPool.getClassLoader(), (Object)parentClass.getClassLoader());
        Class parentAClass = parentA.toClass();
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)parentPool.getClassLoader(), (Object)parentAClass.getClassLoader());
        CtClass childA = childPool.get(SupportClasses.CLASS_A);
        try {
            ClassFactory.createNested(childA, "Test", true);
        }
        catch (Exception e) {
            // empty catch block
        }
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)parentA, (Object)childA);
        ParentFirstDelegatingClassPoolTestCase.assertSame((Object)parentClazz, (Object)childPool.get(SupportClasses.CLASS_A + "$Test"));
    }
}

