/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.base;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.classpool.base.IsLocalResourcePlugin;
import org.jboss.classpool.base.IsLocalResourcePluginFactoryRegistry;
import org.jboss.classpool.spi.AbstractClassPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClassPool
extends AbstractClassPool {
    private IsLocalResourcePlugin isLocalResourcePlugin;

    public BaseClassPool(ClassLoader cl, ClassPool parent, ScopedClassPoolRepository repository) {
        super(cl, parent, repository);
        this.isLocalResourcePlugin = IsLocalResourcePluginFactoryRegistry.getPluginFactory(cl).create(this);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " isLocalResourcePlugin:" + this.isLocalResourcePlugin));
        }
    }

    public BaseClassPool(ClassLoader cl, ClassPool parent, ScopedClassPoolRepository repository, Class<? extends AbstractClassPool.ClassPoolSearchStrategy> searchStrategy) {
        super(cl, parent, repository, searchStrategy);
        this.isLocalResourcePlugin = IsLocalResourcePluginFactoryRegistry.getPluginFactory(cl).create(this);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " isLocalResourcePlugin:" + this.isLocalResourcePlugin));
        }
    }

    public CtClass createCtClass(String classname, boolean useCache) {
        CtClass clazz = super.createCtClass(classname, useCache);
        if (clazz != null) {
            this.lockInCache(clazz);
        }
        return clazz;
    }

    protected CtClass createParentCtClass(String classname, boolean useCache, boolean trace) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof BaseClassPool) {
            return ((BaseClassPool)this.parent).createCtClass(classname, useCache);
        }
        return this.plainParentGet(classname);
    }

    private CtClass plainParentGet(String classname) {
        try {
            return this.parent.get(classname);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    public ClassPool getParent() {
        return this.parent;
    }

    public void setParent(ClassPool parent) {
        this.parent = parent;
    }

    @Override
    protected boolean isLocalClassLoaderResource(String classResourceName) {
        return this.isLocalResourcePlugin.isMyResource(classResourceName);
    }

    public final CtClass get(String classname) throws NotFoundException {
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " initiating get of " + classname));
        }
        if (this.getClassLoader() == null) {
            throw new IllegalStateException("Illegal call.  A class cannot be retrieved from ClassPool " + (Object)((Object)this) + " because the corresponding ClassLoader is garbage collected");
        }
        try {
            CtClass clazz = super.get(classname);
            if (trace) {
                this.logger.trace((Object)((Object)((Object)this) + " completed get of " + classname + " " + this.getClassPoolLogStringForClass(clazz)));
            }
            return clazz;
        }
        catch (NotFoundException e) {
            NotFoundException wrapped = new NotFoundException(e.getMessage() + " could not be found from " + (Object)((Object)this));
            wrapped.setStackTrace(e.getStackTrace());
            throw wrapped;
        }
    }

    public CtClass get0(String classname, boolean useCache) throws NotFoundException {
        return super.get0(classname, useCache);
    }

    @Override
    public void close() {
        super.close();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " closing"));
        }
    }
}

