/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.classpool.base;

import java.net.URI;
import java.net.URL;

import javassist.ClassPool;

import org.jboss.classpool.spi.AbstractClassPool;


/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 97905 $
 */
abstract class AbstractIsLocalResourcePlugin implements IsLocalResourcePlugin
{
   private final BaseClassPool pool;
   
   public AbstractIsLocalResourcePlugin(BaseClassPool pool)
   {
      this.pool = pool;
      initialise();
   }

   protected void initialise()
   {
      
   }
   
   protected AbstractClassPool getPool()
   {
      return pool;
   }
   
   /**
    * Checks if the resource can be found in the parent classpool's loader
    * and returns true if it either does not exist in the parent or if
    * the parent has a different URL for the resource 
    */
   protected boolean isSameInParent(String classResourceName, URL foundURL)
   {
      ClassPool  parent = pool.getParent(); 
      if (parent != null)
      {
         ClassLoader parentLoader = parent.getClassLoader();
         URL parentURL = parentLoader.getResource(classResourceName);
         if (parentURL == null)
         {
            return false;
         }
         URI parentURI = URI.create(parentURL.toString());
         URI foundURI = URI.create(foundURL.toString());
         if (parentURI.equals(foundURI))
         {
            return true;
         }
      }
      
      return false;
   }
}
