/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.classpool.base;

import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolToClassPoolDomainAdaptorFactory;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 99279 $
 */
class DefaultParentDelegationStrategy extends AbstractParentDelegationStrategy
{
   private final boolean parentFirst;
   
   DefaultParentDelegationStrategy(ClassPoolDomain parent, boolean parentFirst, ClassPoolToClassPoolDomainAdaptorFactory adaptorFactory)
   {
      super(parent, adaptorFactory);
      this.parentFirst = parentFirst;
   }
   
   public boolean isParentBefore(String classname)
   {
      boolean isParentBefore = hasParent() && parentFirst == true;
      if (logger.isTraceEnabled()) logger.trace(this + " " + getDomain() + " isParentBefore " + isParentBefore);
      return isParentBefore;
   }
   
   public boolean isParentAfter(String classname)
   {
      boolean isParentAfter = hasParent() && parentFirst == false;
      if (logger.isTraceEnabled()) logger.trace(this + " " + getDomain() + " isParentAfter " + isParentAfter);
      return isParentAfter;
   }

}
