/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.support;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import junit.framework.Assert;
import org.jboss.classpool.spi.AbstractClassPoolFactory;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.test.classpool.support.ClassLoaderFactory;
import org.jboss.test.classpool.support.ClassLoaderInfo;
import org.jboss.test.classpool.support.TestScenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPoolTestScenario<I extends ClassLoaderInfo>
extends TestScenario<CtClass, ClassPool, I> {
    protected ClassPoolRepository repository;

    public ClassPoolTestScenario(ClassLoaderFactory<I> classLoaderFactory) {
        super(classLoaderFactory);
        this.repository = ClassPoolRepository.getInstance();
    }

    public ClassPoolTestScenario(ClassLoaderFactory<I> classLoaderFactory, ClassPoolRepository classPoolRepository) {
        super(classLoaderFactory);
        this.repository = classPoolRepository;
    }

    @Override
    public ClassPool getLoader(CtClass clazz) {
        return this.assertRegisterClassLoader(clazz.getClassPool().getClassLoader());
    }

    @Override
    public ClassPool getLoader(ClassLoader classLoader) {
        return this.assertRegisterClassLoader(classLoader);
    }

    @Override
    public ClassLoader getClassLoader(ClassPool classPool) {
        return classPool.getClassLoader();
    }

    @Override
    public CtClass loadClass(ClassPool classPool, ClassPool expectedClassPool, String className) throws Exception {
        Class<?> clazz = this.assertLoadClass(classPool.getClassLoader(), expectedClassPool.getClassLoader(), className);
        CtClass ctClass = this.assertLoadCtClass(className, classPool, expectedClassPool);
        Assert.assertEquals((String)className, (String)ctClass.getName());
        Assert.assertEquals((String)("Class has been loaded by the wrong class loader: " + className), (Object)clazz.getClassLoader(), (Object)ctClass.getClassPool().getClassLoader());
        return ctClass;
    }

    @Override
    public void cannotLoadClass(ClassPool classPool, String className) {
        try {
            classPool.getCtClass(className);
            Assert.fail((String)("Should not have been able to load " + className));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    public CtClass getMethodReturnType(CtClass clazz, String methodName) throws Exception {
        return clazz.getDeclaredMethod(methodName).getReturnType();
    }

    private ClassPool assertRegisterClassLoader(ClassLoader loader) {
        ClassPool classPool = this.repository.registerClassLoader(loader);
        Assert.assertNotNull((Object)classPool);
        this.assertBootstrap(classPool, String.class, Class.class, ClassLoader.class, Object.class, Collection.class, List.class, Map.class, URL.class);
        return classPool;
    }

    private void assertBootstrap(ClassPool classPool, Class<?> ... classes) {
        this.assertSameClassPool(null, classPool, Integer.TYPE, Boolean.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Void.TYPE);
        this.assertSameClassPool(AbstractClassPoolFactory.getSystemClassPool(), classPool, classes);
    }

    private void assertSameClassPool(ClassPool expectedClassPool, ClassPool classPool, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            CtClass ctClass = null;
            try {
                ctClass = classPool.getCtClass(clazz.getName());
            }
            catch (NotFoundException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            Assert.assertEquals((String)("Class " + clazz.getName() + " loaded by unexpected class pool "), (Object)expectedClassPool, (Object)ctClass.getClassPool());
        }
    }

    protected CtClass assertLoadCtClass(String name, ClassPool initiating, ClassPool expected) throws Exception {
        CtClass clazz = initiating.get(name);
        if (expected != null) {
            Assert.assertSame((Object)expected, (Object)clazz.getClassPool());
        }
        clazz = initiating.get(name);
        if (expected != null) {
            Assert.assertSame((Object)expected, (Object)clazz.getClassPool());
        }
        this.assertLoadCtClassArray(name, clazz, initiating, expected);
        return clazz;
    }

    private void assertLoadCtClassArray(String name, CtClass clazz, ClassPool initiating, ClassPool expected) throws Exception {
        this.assertLoadCtClassArray(name, clazz, 1, initiating, expected);
        this.assertLoadCtClassArray(name, clazz, 2, initiating, expected);
    }

    private void assertLoadCtClassArray(String name, CtClass clazz, int dimensions, ClassPool initiating, ClassPool expected) throws Exception {
        String arrayName = name;
        for (int i = 0; i < dimensions; ++i) {
            arrayName = arrayName + "[]";
        }
        CtClass array = initiating.get(arrayName);
        if (expected != null) {
            Assert.assertSame((Object)expected, (Object)array.getClassPool());
        }
        Assert.assertSame((Object)clazz.getClassPool(), (Object)array.getClassPool());
        CtClass type = array;
        for (int i = 0; i < dimensions; ++i) {
            type = type.getComponentType();
        }
        Assert.assertSame((Object)type, (Object)clazz);
    }

    @Override
    protected void preDestroy(Collection<ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            this.repository.unregisterClassLoader(classLoader);
        }
    }
}

