/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.spi;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javassist.ClassPool;
import org.jboss.classpool.scoped.ScopedClassPool;
import org.jboss.classpool.scoped.ScopedClassPoolFactory;
import org.jboss.classpool.scoped.ScopedClassPoolRepositoryImpl;
import org.jboss.classpool.spi.AbstractClassPoolFactory;
import org.jboss.classpool.spi.ClassLoaderRegistryHandler;
import org.jboss.classpool.spi.ClassLoaderRegistryHandlerFactory;
import org.jboss.classpool.spi.ClassPoolRepositoryCallback;
import org.jboss.classpool.spi.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPoolRepository
extends ScopedClassPoolRepositoryImpl {
    private static final ClassPoolRepository instance = new ClassPoolRepository();
    private volatile List<ClassPoolRepositoryCallback> callbacks;
    private ClassLoaderRegistryHandler registryHandler = new DefaultClassLoaderRegistryHandler();

    public static ClassPoolRepository getInstance() {
        return instance;
    }

    protected ClassPoolRepository() {
        super(AbstractClassPoolFactory.getSystemClassPool());
        super.setClassPoolFactory((ScopedClassPoolFactory)new AbstractClassPoolFactory());
    }

    public void setClassPoolFactory(ScopedClassPoolFactory factory) {
        if (factory instanceof ClassLoaderRegistryHandlerFactory) {
            ClassLoaderRegistryHandlerFactory registryHandlerFactory = (ClassLoaderRegistryHandlerFactory)factory;
            this.registryHandler = registryHandlerFactory.create(new DefaultClassLoaderRegistryHandler());
        }
        super.setClassPoolFactory(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPoolRepositoryCallback(ClassPoolRepositoryCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Null callback");
        }
        if (this.callbacks == null) {
            ClassPoolRepository classPoolRepository = this;
            synchronized (classPoolRepository) {
                if (this.callbacks == null) {
                    this.callbacks = new CopyOnWriteArrayList<ClassPoolRepositoryCallback>();
                }
            }
        }
        this.callbacks.add(callback);
    }

    public List<ClassPoolRepositoryCallback> getClassPoolRepositoryCallbacks() {
        List<ClassPoolRepositoryCallback> cbs = this.callbacks;
        if (cbs == null || cbs.size() == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.callbacks);
    }

    public boolean removeClassPoolRepositoryCallback(ClassPoolRepositoryCallback callback) {
        if (callback == null) {
            return false;
        }
        if (this.callbacks == null) {
            return false;
        }
        return this.callbacks.remove(callback);
    }

    public ClassPool registerClassLoader(ClassLoader classLoader) {
        ClassPool classPool = this.registryHandler.registerClassLoader(classLoader);
        if (this.callbacks != null && this.callbacks.size() > 0) {
            for (ClassPoolRepositoryCallback callback : this.callbacks) {
                callback.classLoaderRegistered(classLoader);
            }
        }
        return classPool;
    }

    public void unregisterClassLoader(ClassLoader classLoader) {
        this.registryHandler.unregisterClassLoader(classLoader);
        if (this.callbacks != null && this.callbacks.size() > 0) {
            for (ClassPoolRepositoryCallback callback : this.callbacks) {
                callback.classLoaderUnregistered(classLoader);
            }
        }
    }

    private class DefaultClassLoaderRegistryHandler
    implements ClassLoaderRegistryHandler {
        private final ConcurrentMap<ClassLoader, Boolean> currentClassLoaders = new ConcurrentHashMap<ClassLoader, Boolean>();

        private DefaultClassLoaderRegistryHandler() {
        }

        public ClassPool registerClassLoader(ClassLoader classLoader) {
            if (classLoader == null) {
                classLoader = SecurityActions.getContextClassLoader();
            }
            if (this.currentClassLoaders.putIfAbsent(classLoader, Boolean.TRUE) != null) {
                return null;
            }
            ScopedClassPool classPool = (ScopedClassPool)ClassPoolRepository.super.registerClassLoader(classLoader);
            this.currentClassLoaders.remove(classLoader);
            return classPool;
        }

        public void unregisterClassLoader(ClassLoader classLoader) {
            ClassPoolRepository.super.unregisterClassLoader(classLoader);
        }

        public void setSuccessor(ClassLoaderRegistryHandler handler) {
            throw new IllegalStateException("Default ClassLoaderRegistryHandler cannot have a sucessor");
        }
    }
}

