/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi;

import java.io.Serializable;
import java.util.ArrayList;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.jboss.deployment.spi.TargetModuleIDImpl;

public class SerializableTargetModuleID
implements Serializable {
    private final long serialVersionUID = 1L;
    private SerializableTargetModuleID parentModuleID;
    private ArrayList childModuleIDs = new ArrayList();
    private String moduleID;
    private int moduleType;
    private boolean isRunning;

    public SerializableTargetModuleID(TargetModuleIDImpl impl) {
        this(null, impl);
    }

    public SerializableTargetModuleID(SerializableTargetModuleID parent, TargetModuleIDImpl impl) {
        this.parentModuleID = parent;
        this.moduleID = impl.getModuleID();
        this.moduleType = impl.getModuleType().getValue();
        TargetModuleID[] children = impl.getChildTargetModuleID();
        int length = children != null ? children.length : 0;
        for (int n = 0; n < length; ++n) {
            TargetModuleIDImpl child = (TargetModuleIDImpl)children[n];
            this.childModuleIDs.add(new SerializableTargetModuleID(this, child));
        }
    }

    public SerializableTargetModuleID(SerializableTargetModuleID parent, String moduleID, int moduleType, boolean isRunning) {
        this.parentModuleID = parent;
        this.moduleID = moduleID;
        this.moduleType = moduleType;
        this.isRunning = isRunning;
    }

    public SerializableTargetModuleID getParentModuleID() {
        return this.parentModuleID;
    }

    public void addChildTargetModuleID(SerializableTargetModuleID child) {
        this.childModuleIDs.add(child);
    }

    public void clearChildModuleIDs() {
        this.childModuleIDs.clear();
    }

    public SerializableTargetModuleID[] getChildModuleIDs() {
        SerializableTargetModuleID[] ids = new SerializableTargetModuleID[this.childModuleIDs.size()];
        this.childModuleIDs.toArray(ids);
        return ids;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public int getModuleType() {
        return this.moduleType;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean flag) {
        this.isRunning = flag;
    }

    public String toString() {
        return "SerializableTargetModuleID{parentModuleID=@" + System.identityHashCode(this.parentModuleID) + ", childModuleIDs=" + this.childModuleIDs + ", moduleID='" + this.moduleID + "'" + ", moduleType=" + this.moduleType + ", isRunning=" + this.isRunning + "}";
    }
}

