/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.jrmp.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerProxyHA;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.PayloadKey;
import org.jboss.invocation.ServiceUnavailableException;
import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxy;
import org.jboss.logging.Logger;

public class JRMPInvokerProxyHA
extends JRMPInvokerProxy
implements InvokerProxyHA,
Externalizable {
    private static final long serialVersionUID = -967671822225981666L;
    private static final Logger log = Logger.getLogger(JRMPInvokerProxyHA.class);
    public static final WeakHashMap txFailoverAuthorizations = new WeakHashMap();
    protected LoadBalancePolicy loadBalancePolicy;
    protected String proxyFamilyName = null;
    FamilyClusterInfo familyClusterInfo = null;
    protected transient boolean trace = false;

    public JRMPInvokerProxyHA() {
    }

    public JRMPInvokerProxyHA(ArrayList targets, LoadBalancePolicy policy, String proxyFamilyName, long viewId) {
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget(proxyFamilyName, targets, viewId);
        this.loadBalancePolicy = policy;
        this.proxyFamilyName = proxyFamilyName;
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace("Init, cluterInfo: " + this.familyClusterInfo + ", policy=" + this.loadBalancePolicy);
        }
    }

    public void updateClusterInfo(ArrayList targets, long viewId) {
        if (this.familyClusterInfo != null) {
            this.familyClusterInfo.updateClusterInfo(targets, viewId);
        }
    }

    public Object getRemoteTarget() {
        return this.getRemoteTarget(null);
    }

    public Object getRemoteTarget(Invocation invocationBasedRouting) {
        return this.loadBalancePolicy.chooseTarget(this.familyClusterInfo, invocationBasedRouting);
    }

    public void remoteTargetHasFailed(Object target) {
        this.removeDeadTarget(target);
    }

    protected void removeDeadTarget(Object target) {
        if (this.familyClusterInfo != null) {
            this.familyClusterInfo.removeDeadTarget(target);
        }
    }

    protected int totalNumberOfTargets() {
        if (this.familyClusterInfo != null) {
            return this.familyClusterInfo.getTargets().size();
        }
        return 0;
    }

    protected void resetView() {
        this.familyClusterInfo.resetView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean txContextAllowsFailover(Invocation invocation) {
        Transaction tx = invocation.getTransaction();
        if (tx != null) {
            Transaction transaction = tx;
            synchronized (transaction) {
                return !txFailoverAuthorizations.containsKey(tx);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invocationHasReachedAServer(Invocation invocation) {
        Transaction tx = invocation.getTransaction();
        if (tx != null) {
            Transaction transaction = tx;
            synchronized (transaction) {
                txFailoverAuthorizations.put(tx, null);
            }
        }
    }

    public Object invoke(Invocation invocation) throws Exception {
        int failoverCounter = 0;
        invocation.setValue("FAILOVER_COUNTER", new Integer(failoverCounter), PayloadKey.AS_IS);
        MarshalledInvocation mi = new MarshalledInvocation(invocation);
        mi.setTransactionPropagationContext(this.getTransactionPropagationContext());
        mi.setValue("CLUSTER_VIEW_ID", new Long(this.familyClusterInfo.getCurrentViewId()));
        Invoker target = (Invoker)this.getRemoteTarget(invocation);
        boolean failoverAuthorized = true;
        Exception lastException = null;
        while (target != null && failoverAuthorized) {
            boolean definitivlyRemoveNodeOnFailure = true;
            try {
                if (this.trace) {
                    log.trace("Invoking on target=" + target);
                }
                Object rtnObj = target.invoke(mi);
                HARMIResponse rsp = null;
                rsp = rtnObj instanceof MarshalledObject ? (HARMIResponse)((MarshalledObject)rtnObj).get() : (HARMIResponse)rtnObj;
                if (rsp.newReplicants != null) {
                    if (this.trace) {
                        log.trace("newReplicants: " + rsp.newReplicants);
                    }
                    this.updateClusterInfo(rsp.newReplicants, rsp.currentViewId);
                }
                this.invocationHasReachedAServer(invocation);
                return rsp.response;
            }
            catch (ConnectException e) {
                lastException = e;
            }
            catch (UnknownHostException e) {
                lastException = e;
            }
            catch (java.rmi.ConnectException e) {
                lastException = e;
            }
            catch (ConnectIOException e) {
                lastException = e;
            }
            catch (NoSuchObjectException e) {
                lastException = e;
            }
            catch (java.rmi.UnknownHostException e) {
                lastException = e;
            }
            catch (GenericClusteringException e) {
                lastException = e;
                if (e.getCompletionStatus() == 1) {
                    if (this.totalNumberOfTargets() >= failoverCounter && !e.isDefinitive()) {
                        definitivlyRemoveNodeOnFailure = false;
                    }
                }
                this.invocationHasReachedAServer(invocation);
                throw new ServerException("Clustering error", e);
            }
            catch (ServerException e) {
                this.invocationHasReachedAServer(invocation);
                if (e.detail instanceof TransactionRolledbackException) {
                    throw (TransactionRolledbackException)e.detail;
                }
                if (e.detail instanceof RemoteException) {
                    throw (RemoteException)e.detail;
                }
                throw e;
            }
            catch (Exception e) {
                lastException = e;
                this.invocationHasReachedAServer(invocation);
                throw e;
            }
            if (this.trace) {
                log.trace("Invoke failed, target=" + target, lastException);
            }
            this.remoteTargetHasFailed(target);
            if (!definitivlyRemoveNodeOnFailure) {
                this.resetView();
            }
            failoverAuthorized = this.txContextAllowsFailover(invocation);
            target = (Invoker)this.getRemoteTarget(invocation);
            mi.setValue("FAILOVER_COUNTER", new Integer(++failoverCounter), PayloadKey.AS_IS);
        }
        String msg = "Service unavailable.";
        if (!failoverAuthorized) {
            msg = "Service unavailable (failover not possible inside a user transaction).";
        }
        throw new ServiceUnavailableException(msg, lastException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        ArrayList targets = null;
        long vid = 0L;
        FamilyClusterInfo familyClusterInfo = this.familyClusterInfo;
        synchronized (familyClusterInfo) {
            targets = this.familyClusterInfo.getTargets();
            vid = this.familyClusterInfo.getCurrentViewId();
        }
        out.writeObject(targets);
        out.writeObject(this.loadBalancePolicy);
        out.writeObject(this.proxyFamilyName);
        out.writeLong(vid);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ArrayList targets = (ArrayList)in.readObject();
        this.loadBalancePolicy = (LoadBalancePolicy)in.readObject();
        this.proxyFamilyName = (String)in.readObject();
        long vid = in.readLong();
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget(this.proxyFamilyName, targets, vid);
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace("Init, clusterInfo: " + this.familyClusterInfo + ", policy=" + this.loadBalancePolicy);
        }
    }
}

